/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.handler;

import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import fuzs.forgeconfigapiport.mixin.accessor.LevelResourceAccessor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfig;

public class ServerLifecycleHandler {
    public static final class_2960 BEFORE_PHASE = ForgeConfigAPIPort.id("before");
    public static final class_2960 AFTER_PHASE = ForgeConfigAPIPort.id("after");
    private static final class_5218 SERVER_CONFIG_LEVEL_RESOURCE = LevelResourceAccessor.forgeconfigapiport$create("serverconfig");

    public static void onServerStarting(MinecraftServer server) {
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ServerLifecycleHandler.getServerConfigPath(server));
        net.neoforged.fml.config.ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ServerLifecycleHandler.getServerConfigPath(server));
    }

    public static void onServerStopped(MinecraftServer server) {
        ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ServerLifecycleHandler.getServerConfigPath(server));
        net.neoforged.fml.config.ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ServerLifecycleHandler.getServerConfigPath(server));
    }

    public static Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.method_27050(SERVER_CONFIG_LEVEL_RESOURCE);
        if (!Files.isDirectory(serverConfig, new LinkOption[0])) {
            try {
                Files.createDirectories(serverConfig, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return serverConfig;
    }
}

