/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.network.client.config;

import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import fuzs.forgeconfigapiport.impl.network.client.NetworkHooks;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_635;
import net.minecraftforge.fml.config.ConfigTracker;
import org.jetbrains.annotations.Nullable;

public final class ConfigSyncClient {
    private ConfigSyncClient() {
    }

    public static CompletableFuture<@Nullable class_2540> onSyncConfigs(class_310 client, class_635 handler, class_2540 buf) {
        String fileName = ConfigSyncClient.receiveSyncedConfig(buf);
        ForgeConfigAPIPort.LOGGER.debug("Received config sync for {} from server", (Object)fileName);
        class_2540 response = new class_2540(Unpooled.buffer());
        response.method_10814(fileName);
        ForgeConfigAPIPort.LOGGER.debug("Sent config sync for {} to server", (Object)fileName);
        return CompletableFuture.completedFuture(response);
    }

    public static CompletableFuture<@Nullable class_2540> onEstablishModdedConnection(class_310 client, class_635 handler, class_2540 buf) {
        ForgeConfigAPIPort.LOGGER.debug("Received modded connection marker from server");
        NetworkHooks.setModdedConnection();
        return CompletableFuture.completedFuture(new class_2540(Unpooled.buffer()));
    }

    private static String receiveSyncedConfig(class_2540 buf) {
        String fileName = buf.method_10800(Short.MAX_VALUE);
        byte[] fileData = buf.method_10795();
        if (!class_310.method_1551().method_1542()) {
            Optional.ofNullable(ConfigTracker.INSTANCE.fileMap().get(fileName)).ifPresent(config -> config.acceptSyncedConfig(fileData));
            Optional.ofNullable(net.neoforged.fml.config.ConfigTracker.INSTANCE.fileMap().get(fileName)).ifPresent(config -> config.acceptSyncedConfig(fileData));
        }
        return fileName;
    }
}

