/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.logging.LogUtils;
import fuzs.forgeconfigapiport.impl.config.ForgeConfigApiPortConfig;
import fuzs.forgeconfigapiport.impl.core.CommonAbstractions;
import fuzs.forgeconfigapiport.impl.util.ConfigLoadingHelper;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public class ConfigFileTypeHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    static ConfigFileTypeHandler TOML = new ConfigFileTypeHandler();
    private static final Path defaultConfigPath = CommonAbstractions.INSTANCE.getDefaultConfigsDirectory();

    public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
        return c -> {
            Path configPath = configBasePath.resolve(c.getFileName());
            if (((Boolean)ForgeConfigApiPortConfig.INSTANCE.getValue("forceGlobalServerConfigs")).booleanValue() && Files.notExists(configPath, new LinkOption[0])) {
                configPath = CommonAbstractions.INSTANCE.getConfigDirectory().resolve(c.getFileName());
            }
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder(configPath, (ConfigFormat<? extends CommentedConfig>)TomlFormat.instance()).sync().preserveInsertionOrder().autosave().onFileNotFound((newfile, configFormat) -> this.setupConfigFile((ModConfig)c, newfile, configFormat)).writingMode(WritingMode.REPLACE).build();
            LOGGER.debug(ConfigTracker.CONFIG, "Built TOML config for {}", (Object)configPath);
            try {
                ConfigLoadingHelper.tryLoadConfigFile(configData);
            }
            catch (ParsingException ex) {
                throw new ConfigLoadingException((ModConfig)c, ex);
            }
            ConfigLoadingHelper.tryRegisterDefaultConfig(c.getFileName());
            LOGGER.debug(ConfigTracker.CONFIG, "Loaded TOML config file {}", (Object)configPath);
            try {
                FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher((ModConfig)c, configData, Thread.currentThread().getContextClassLoader()));
                LOGGER.debug(ConfigTracker.CONFIG, "Watching TOML config file {} for changes", (Object)configPath);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't watch config file", e);
            }
            return configData;
        };
    }

    public void unload(Path configBasePath, ModConfig config) {
        Path configPath = configBasePath.resolve(config.getFileName());
        try {
            FileWatcher.defaultInstance().removeWatch(configBasePath.resolve(config.getFileName()));
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath, (Object)e);
        }
    }

    private boolean setupConfigFile(ModConfig modConfig, Path file, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path p = defaultConfigPath.resolve(modConfig.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            LOGGER.info(ConfigTracker.CONFIG, "Loading default config file from path {}", (Object)p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig) {
        ConfigFileTypeHandler.backUpConfig(commentedFileConfig, 5);
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig, int maxBackups) {
        Path bakFileLocation = commentedFileConfig.getNioPath().getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFile().getName());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFile().getName()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig.getNioPath(), bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            LOGGER.warn(ConfigTracker.CONFIG, "Failed to back up config file {}", (Object)commentedFileConfig.getNioPath(), (Object)exception);
        }
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for modid " + config.getModId(), cause);
        }
    }

    private static class ConfigWatcher
    implements Runnable {
        private final ModConfig modConfig;
        private final CommentedFileConfig commentedFileConfig;
        private final ClassLoader realClassLoader;

        ConfigWatcher(ModConfig modConfig, CommentedFileConfig commentedFileConfig, ClassLoader classLoader) {
            this.modConfig = modConfig;
            this.commentedFileConfig = commentedFileConfig;
            this.realClassLoader = classLoader;
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.modConfig.getSpec().isCorrecting()) {
                try {
                    this.commentedFileConfig.load();
                    if (!this.modConfig.getSpec().isCorrect(this.commentedFileConfig)) {
                        LOGGER.warn(ConfigTracker.CONFIG, "Configuration file {} is not correct. Correcting", (Object)this.commentedFileConfig.getFile().getAbsolutePath());
                        ConfigFileTypeHandler.backUpConfig(this.commentedFileConfig);
                        this.modConfig.getSpec().correct(this.commentedFileConfig);
                        this.commentedFileConfig.save();
                    }
                }
                catch (ParsingException ex) {
                    throw new ConfigLoadingException(this.modConfig, ex);
                }
                LOGGER.debug(ConfigTracker.CONFIG, "Config file {} changed, sending notifies", (Object)this.modConfig.getFileName());
                this.modConfig.getSpec().afterReload();
                CommonAbstractions.INSTANCE.fireConfigReloadingV3(this.modConfig.getModId(), this.modConfig);
            }
        }
    }
}

