/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.ui.render;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class AdvancementPlaque {
    private final AdvancementToast toast;
    private long animationTime = -1L;
    private long visibleTime = -1L;
    private boolean hasPlayedSound = false;
    private Toast.Visibility visibility = Toast.Visibility.SHOW;
    private Minecraft mc;
    private CustomItemRenderer itemRenderer;

    public AdvancementPlaque(AdvancementToast toastIn, Minecraft mcIn, CustomItemRenderer itemRendererIn) {
        this.toast = toastIn;
        this.mc = mcIn;
        this.itemRenderer = itemRendererIn;
    }

    public AdvancementToast getToast() {
        return this.toast;
    }

    public int width() {
        return 256;
    }

    public int height() {
        return 32;
    }

    private float getVisibility(long currentTime) {
        float f = Mth.m_14036_((float)((float)(currentTime - this.animationTime) / 200.0f), (float)0.0f, (float)1.0f);
        f *= f;
        return this.visibility == Toast.Visibility.HIDE ? 1.0f - f : f;
    }

    private Toast.Visibility drawPlaque(GuiGraphics graphics, long displayTime) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof PauseScreen || mc.f_91080_ instanceof LevelLoadingScreen) {
            return Toast.Visibility.SHOW;
        }
        DisplayInfo displayInfo = this.toast.f_94795_.f_290952_().f_138299_().orElse(null);
        PoseStack poseStack = graphics.m_280168_();
        if (displayInfo != null) {
            float alpha;
            float fadeOutTime;
            float fadeInTime;
            float duration = switch (displayInfo.m_14992_()) {
                default -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskDuration.get() * 1000.0);
                }
                case FrameType.GOAL -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalDuration.get() * 1000.0);
                }
                case FrameType.CHALLENGE -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeDuration.get() * 1000.0);
                }
            };
            if ((float)displayTime >= fadeInTime) {
                alpha = 1.0f;
                if ((float)displayTime > duration) {
                    alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - ((float)displayTime - duration) / 1000.0f));
                }
                int titleColor = AdvancementPlaquesConfig.INSTANCE.getTitleColor(alpha).m_131265_();
                int nameColor = AdvancementPlaquesConfig.INSTANCE.getNameColor(alpha).m_131265_();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)AdvancementPlaques.TEXTURE_PLAQUES);
                int frameOffset = 0;
                if (displayInfo.m_14992_() == FrameType.GOAL) {
                    frameOffset = 1;
                } else if (displayInfo.m_14992_() == FrameType.CHALLENGE) {
                    frameOffset = 2;
                }
                GuiHelper.blit((PoseStack)graphics.m_280168_(), (int)-1, (int)-1, (int)this.width(), (int)this.height(), (float)0.0f, (float)(this.height() * frameOffset), (int)this.width(), (int)this.height(), (int)256, (int)256);
                if (alpha > 0.1f) {
                    int typeWidth = mc.f_91062_.m_92852_((FormattedText)displayInfo.m_14992_().m_15553_());
                    mc.f_91062_.m_272077_(displayInfo.m_14992_().m_15553_(), (float)((int)((float)(this.width() - typeWidth) / 2.0f + 15.0f)), 5.0f, titleColor, false, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                    int titleWidth = mc.f_91062_.m_92852_((FormattedText)displayInfo.m_14977_());
                    if ((float)titleWidth <= 146.66667f) {
                        poseStack.m_85836_();
                        poseStack.m_85841_(1.5f, 1.5f, 1.0f);
                        mc.f_91062_.m_272077_(displayInfo.m_14977_(), (float)((int)(((float)this.width() / 1.5f - (float)titleWidth) / 2.0f + 10.0f)), 9.0f, nameColor, false, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                        poseStack.m_85849_();
                    } else {
                        mc.f_91062_.m_272077_(displayInfo.m_14977_(), (float)((int)((float)(this.width() - titleWidth) / 2.0f + 15.0f)), 15.0f, nameColor, false, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                    }
                    graphics.m_280262_();
                }
                poseStack.m_85836_();
                poseStack.m_252880_(1.0f, 1.0f, 0.0f);
                poseStack.m_85841_(1.5f, 1.5f, 1.0f);
                this.itemRenderer.renderItemModelIntoGUIWithAlpha(poseStack, displayInfo.m_14990_(), 1, 1, alpha);
                poseStack.m_85849_();
                if (!this.hasPlayedSound) {
                    this.hasPlayedSound = true;
                    try {
                        switch (displayInfo.m_14992_()) {
                            case TASK: {
                                if ((Double)AdvancementPlaquesConfig.INSTANCE.taskVolume.get() > 0.0) {
                                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)AdvancementPlaques.TASK_COMPLETE.get()), (float)1.0f, (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskVolume.get()).floatValue()));
                                }
                                break;
                            }
                            case GOAL: {
                                if ((Double)AdvancementPlaquesConfig.INSTANCE.goalVolume.get() > 0.0) {
                                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)AdvancementPlaques.GOAL_COMPLETE.get()), (float)1.0f, (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalVolume.get()).floatValue()));
                                }
                                break;
                            }
                            default: {
                                if ((Double)AdvancementPlaquesConfig.INSTANCE.challengeVolume.get() > 0.0) {
                                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12496_, (float)1.0f, (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeVolume.get()).floatValue()));
                                }
                                break;
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        AdvancementPlaques.LOGGER.warn("Tried to play a custom sound for an advancement, but that sound was not registered! Install Advancement Plaques on the server or mute tasks and goals in the config file.");
                    }
                }
            }
            if ((float)displayTime < fadeInTime + fadeOutTime) {
                alpha = 1.0f - ((float)displayTime - fadeInTime) / fadeOutTime;
                if ((float)displayTime < fadeInTime) {
                    alpha = (float)displayTime / fadeInTime;
                }
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, 95.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)AdvancementPlaques.TEXTURE_PLAQUE_EFFECTS);
                if (displayInfo.m_14992_() == FrameType.CHALLENGE) {
                    GuiHelper.blit((PoseStack)poseStack, (int)-16, (int)-16, (int)(this.width() + 32), (int)(this.height() + 32), (float)0.0f, (float)(this.height() + 32), (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                } else {
                    GuiHelper.blit((PoseStack)poseStack, (int)-16, (int)-16, (int)(this.width() + 32), (int)(this.height() + 32), (float)0.0f, (float)0.0f, (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                }
                poseStack.m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            return (float)displayTime >= fadeInTime + fadeOutTime + duration ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }

    public boolean render(int screenWidth, int index, GuiGraphics graphics) {
        long currentTime = Util.m_137550_();
        if (this.animationTime == -1L) {
            this.animationTime = currentTime;
            this.visibility.m_94909_(this.mc.m_91106_());
        }
        if (this.visibility == Toast.Visibility.SHOW && currentTime - this.animationTime <= 200L) {
            this.visibleTime = currentTime;
        }
        RenderSystem.disableDepthTest();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        if (((Boolean)AdvancementPlaquesConfig.INSTANCE.onTop.get()).booleanValue()) {
            poseStack.m_252880_((float)(graphics.m_280182_() - this.width()) / 2.0f, (float)((Integer)AdvancementPlaquesConfig.INSTANCE.distance.get()).intValue(), 800.0f + (float)index);
        } else {
            poseStack.m_252880_((float)(graphics.m_280182_() - this.width()) / 2.0f, (float)(this.mc.m_91268_().m_85446_() - (this.height() + (Integer)AdvancementPlaquesConfig.INSTANCE.distance.get())), 800.0f + (float)index);
        }
        Toast.Visibility newVisibility = this.drawPlaque(graphics, currentTime - this.visibleTime);
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        if (newVisibility != this.visibility) {
            this.animationTime = currentTime - (long)((int)((1.0f - this.getVisibility(currentTime)) * 200.0f));
            this.visibility = newVisibility;
        }
        return this.visibility == Toast.Visibility.HIDE && currentTime - this.animationTime > 200L;
    }
}

