/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ICustomCollisions;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.MovementControllerCustomCollisions;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RewindableStream;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityTiger
extends Animal
implements ICustomCollisions,
IAnimatedEntity,
NeutralMob,
ITargetsDroppedItems {
    public static final Animation ANIMATION_PAW_R = Animation.create((int)15);
    public static final Animation ANIMATION_PAW_L = Animation.create((int)15);
    public static final Animation ANIMATION_TAIL_FLICK = Animation.create((int)45);
    public static final Animation ANIMATION_LEAP = Animation.create((int)20);
    private static final EntityDataAccessor<Boolean> WHITE = SynchedEntityData.m_135353_(EntityTiger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(EntityTiger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(EntityTiger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(EntityTiger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STEALTH_MODE = SynchedEntityData.m_135353_(EntityTiger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HOLDING = SynchedEntityData.m_135353_(EntityTiger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(EntityTiger.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LAST_SCARED_MOB_ID = SynchedEntityData.m_135353_(EntityTiger.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGRY_TIMER = TimeUtil.m_145020_((int)40, (int)80);
    private static final Predicate<LivingEntity> NO_BLESSING_EFFECT = mob -> !mob.m_21023_(AMEffectRegistry.TIGERS_BLESSING);
    public float prevSitProgress;
    public float sitProgress;
    public float prevSleepProgress;
    public float sleepProgress;
    public float prevHoldProgress;
    public float holdProgress;
    public float prevStealthProgress;
    public float stealthProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean hasSpedUp = false;
    private UUID lastHurtBy;
    private int sittingTime;
    private int maxSitTime;
    private int holdTime = 0;
    private int prevScaredMobId = -1;
    private boolean dontSitFlag = false;

    protected EntityTiger(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.f_21342_ = new MovementControllerCustomCollisions((Mob)this);
    }

    public static boolean canTigerSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random random) {
        return worldIn.m_45524_(pos, 0) > 8;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 86.0);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.tigerSpawnRolls, this.m_21187_(), spawnReasonIn);
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_6425_(pos.m_7495_()).m_76178_() && worldIn.m_6425_(pos).m_76153_((Tag)FluidTags.f_13131_) ? 0.0f : super.m_5610_(pos, worldIn);
    }

    public boolean m_6914_(LevelReader worldIn) {
        return !worldIn.m_46855_(this.m_142469_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("TigerSitting", this.isSitting());
        compound.m_128379_("TigerSleeping", this.m_5803_());
        compound.m_128379_("White", this.isWhite());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSitting(compound.m_128471_("TigerSitting"));
        this.setSleeping(compound.m_128471_("TigerSleeping"));
        this.setWhite(compound.m_128471_("White"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WHITE, (Object)false);
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(STEALTH_MODE, (Object)false);
        this.f_19804_.m_135372_(HOLDING, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(LAST_SCARED_MOB_ID, (Object)-1);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AnimalAIPanicBaby(this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new AIMelee());
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 60, 1.0, 14, 7));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 25.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new CreatureAITargetItems((PathfinderMob)this, false, 10));
        this.f_21346_.m_25352_(2, (Goal)new AngerGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new AttackPlayerGoal());
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, false, false, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.m_13126_().m_13404_(AMTagRegistry.TIGER_TARGETS))){

            public boolean m_8036_() {
                return !EntityTiger.this.m_6162_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected SoundEvent m_7515_() {
        return this.isStealth() ? super.m_7515_() : (this.m_6784_() > 0 ? AMSoundRegistry.TIGER_ANGRY : AMSoundRegistry.TIGER_IDLE);
    }

    public int m_8100_() {
        return this.m_6784_() > 0 ? 40 : 80;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return AMSoundRegistry.TIGER_HURT;
    }

    protected SoundEvent m_5592_() {
        return AMSoundRegistry.TIGER_HURT;
    }

    protected float m_6108_() {
        return 0.99f;
    }

    public boolean shouldMove() {
        return !this.isSitting() && !this.m_5803_() && !this.isHolding();
    }

    public double m_20968_(@Nullable Entity lookingEntity) {
        if (this.isStealth()) {
            return 0.2;
        }
        return super.m_20968_(lookingEntity);
    }

    public boolean m_6898_(ItemStack stack) {
        return ItemTags.m_13193_().m_13404_(AMTagRegistry.TIGER_BREEDABLES).m_8110_((Object)stack.m_41720_());
    }

    public void m_5837_(ServerLevel world, LivingEntity entity) {
        this.m_5634_(5.0f);
        super.m_5837_(world, entity);
    }

    public void m_7023_(Vec3 vec3d) {
        if (!this.shouldMove()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new Navigator((Mob)this, worldIn);
    }

    public boolean isWhite() {
        return (Boolean)this.f_19804_.m_135370_(WHITE);
    }

    public void setWhite(boolean white) {
        this.f_19804_.m_135381_(WHITE, (Object)white);
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean running) {
        this.f_19804_.m_135381_(RUNNING, (Object)running);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean bar) {
        this.f_19804_.m_135381_(SITTING, (Object)bar);
    }

    public boolean isStealth() {
        return (Boolean)this.f_19804_.m_135370_(STEALTH_MODE);
    }

    public void setStealth(boolean bar) {
        this.f_19804_.m_135381_(STEALTH_MODE, (Object)bar);
    }

    public boolean isHolding() {
        return (Boolean)this.f_19804_.m_135370_(HOLDING);
    }

    public void setHolding(boolean running) {
        this.f_19804_.m_135381_(HOLDING, (Object)running);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.lastHurtBy;
    }

    public void m_6925_(@Nullable UUID target) {
        this.lastHurtBy = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGRY_TIMER.m_142270_(this.f_19796_));
    }

    protected void m_8024_() {
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, false);
        }
    }

    public void m_8119_() {
        Entity e;
        super.m_8119_();
        this.prevSitProgress = this.sitProgress;
        this.prevSleepProgress = this.sleepProgress;
        this.prevHoldProgress = this.holdProgress;
        this.prevStealthProgress = this.stealthProgress;
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.m_5803_() && this.sleepProgress < 5.0f) {
            this.sleepProgress += 1.0f;
        }
        if (!this.m_5803_() && this.sleepProgress > 0.0f) {
            this.sleepProgress -= 1.0f;
        }
        if (this.isHolding() && this.holdProgress < 5.0f) {
            this.holdProgress += 1.0f;
        }
        if (!this.isHolding() && this.holdProgress > 0.0f) {
            this.holdProgress -= 1.0f;
        }
        if (this.isStealth() && this.stealthProgress < 10.0f) {
            this.stealthProgress += 0.25f;
        }
        if (!this.isStealth() && this.stealthProgress > 0.0f) {
            this.stealthProgress -= 1.0f;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.isRunning() && !this.hasSpedUp) {
                this.hasSpedUp = true;
                this.f_19793_ = 1.0f;
                this.m_6858_(true);
                this.m_21051_(Attributes.f_22279_).m_22100_((double)0.4f);
            }
            if (!this.isRunning() && this.hasSpedUp) {
                this.hasSpedUp = false;
                this.f_19793_ = 0.6f;
                this.m_6858_(false);
                this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
            }
            if ((this.isSitting() || this.m_5803_()) && (++this.sittingTime > this.maxSitTime || this.m_5448_() != null || this.m_27593_() || this.dontSitFlag || this.m_20072_())) {
                this.setSitting(false);
                this.setSleeping(false);
                this.sittingTime = 0;
                this.maxSitTime = 100 + this.f_19796_.nextInt(50);
            }
            if (!(this.m_5448_() != null || this.dontSitFlag || !(this.m_20184_().m_82556_() < 0.03) || this.getAnimation() != NO_ANIMATION || this.m_5803_() || this.isSitting() || this.m_20072_() || this.f_19796_.nextInt(100) != 0)) {
                this.sittingTime = 0;
                if (this.m_21187_().nextBoolean()) {
                    this.maxSitTime = 100 + this.f_19796_.nextInt(550);
                    this.setSitting(true);
                    this.setSleeping(false);
                } else {
                    this.maxSitTime = 200 + this.f_19796_.nextInt(550);
                    this.setSitting(false);
                    this.setSleeping(true);
                }
            }
            if (this.m_20184_().m_82556_() < 0.03 && this.getAnimation() == NO_ANIMATION && !this.m_5803_() && !this.isSitting() && this.f_19796_.nextInt(100) == 0) {
                this.setAnimation(ANIMATION_TAIL_FLICK);
            }
        }
        if (this.isHolding()) {
            this.m_6858_(false);
            this.setRunning(false);
            if (!this.f_19853_.f_46443_ && this.m_5448_() != null && this.m_5448_().m_6084_()) {
                this.m_146926_(0.0f);
                float radius = 1.0f + this.m_5448_().m_20205_() * 0.5f;
                float angle = (float)Math.PI / 180 * this.f_20883_;
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * Mth.m_14089_((float)angle);
                double extraY = -0.5;
                Vec3 minus = new Vec3(this.m_20185_() + extraX - this.m_5448_().m_20185_(), this.m_20186_() + extraY - this.m_5448_().m_20186_(), this.m_20189_() + extraZ - this.m_5448_().m_20189_());
                this.m_5448_().m_20256_(minus);
                if (this.holdTime % 20 == 0) {
                    this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(5 + this.m_21187_().nextInt(2)));
                }
            }
            ++this.holdTime;
            if (this.holdTime > 100) {
                this.holdTime = 0;
                this.setHolding(false);
            }
        } else {
            this.holdTime = 0;
        }
        if (this.prevScaredMobId != (Integer)this.f_19804_.m_135370_(LAST_SCARED_MOB_ID) && this.f_19853_.f_46443_ && (e = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(LAST_SCARED_MOB_ID)).intValue())) != null) {
            double d2 = this.f_19796_.nextGaussian() * 0.1;
            double d0 = this.f_19796_.nextGaussian() * 0.1;
            double d1 = this.f_19796_.nextGaussian() * 0.1;
            this.f_19853_.m_7106_((ParticleOptions)AMParticleRegistry.SHOCKED, e.m_20185_(), e.m_20188_() + (double)(e.m_20206_() * 0.15f) + (double)(this.f_19796_.nextFloat() * e.m_20206_() * 0.15f), e.m_20189_(), d0, d1, d2);
        }
        if (this.m_5448_() != null && this.m_5448_().m_21023_(AMEffectRegistry.TIGERS_BLESSING)) {
            this.m_6710_(null);
            this.m_6703_(null);
        }
        this.prevScaredMobId = (Integer)this.f_19804_.m_135370_(LAST_SCARED_MOB_ID);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean prev = super.m_6469_(source, amount);
        if (prev) {
            LivingEntity hurter;
            if (source.m_7639_() != null && source.m_7639_() instanceof LivingEntity && (hurter = (LivingEntity)source.m_7639_()).m_21023_(AMEffectRegistry.TIGERS_BLESSING)) {
                hurter.m_21195_(AMEffectRegistry.TIGERS_BLESSING);
            }
            return prev;
        }
        return prev;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public BlockPos getLightPosition() {
        BlockPos pos = new BlockPos(this.m_20182_());
        if (!this.f_19853_.m_8055_(pos).m_60815_()) {
            return pos.m_7494_();
        }
        return pos;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        boolean whiteOther = p_241840_2_ instanceof EntityTiger && ((EntityTiger)p_241840_2_).isWhite();
        EntityTiger baby = (EntityTiger)AMEntityRegistry.TIGER.m_20615_((Level)p_241840_1_);
        double whiteChance = 0.1;
        if (this.isWhite() && whiteOther) {
            whiteChance = 0.8;
        }
        if (this.isWhite() != whiteOther) {
            whiteChance = 0.4;
        }
        baby.setWhite(this.f_19796_.nextDouble() < whiteChance);
        return baby;
    }

    public Vec3 m_20272_(Vec3 vec) {
        boolean flag3;
        AABB axisalignedbb = this.m_142469_();
        CollisionContext iselectioncontext = CollisionContext.m_82750_((Entity)this);
        VoxelShape voxelshape = this.f_19853_.m_6857_().m_61946_();
        Stream<Object> stream = Shapes.m_83157_((VoxelShape)voxelshape, (VoxelShape)Shapes.m_83064_((AABB)axisalignedbb.m_82406_(1.0E-7)), (BooleanOp)BooleanOp.f_82689_) ? Stream.empty() : Stream.of(voxelshape);
        Stream stream1 = this.f_19853_.m_5454_((Entity)this, axisalignedbb.m_82369_(vec), p_233561_0_ -> true);
        RewindableStream reuseablestream = new RewindableStream(Stream.concat(stream1, stream));
        Vec3 vector3d = vec.m_82556_() == 0.0 ? vec : this.collideBoundingBoxHeuristicallyPassable((Entity)this, vec, axisalignedbb, this.f_19853_, iselectioncontext, reuseablestream);
        boolean flag = vec.f_82479_ != vector3d.f_82479_;
        boolean flag1 = vec.f_82480_ != vector3d.f_82480_;
        boolean flag2 = vec.f_82481_ != vector3d.f_82481_;
        boolean bl = flag3 = this.f_19861_ || flag1 && vec.f_82480_ < 0.0;
        if (this.f_19793_ > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vector3d3;
            Vec3 vector3d1 = this.collideBoundingBoxHeuristicallyPassable((Entity)this, new Vec3(vec.f_82479_, (double)this.f_19793_, vec.f_82481_), axisalignedbb, this.f_19853_, iselectioncontext, reuseablestream);
            Vec3 vector3d2 = this.collideBoundingBoxHeuristicallyPassable((Entity)this, new Vec3(0.0, (double)this.f_19793_, 0.0), axisalignedbb.m_82363_(vec.f_82479_, 0.0, vec.f_82481_), this.f_19853_, iselectioncontext, reuseablestream);
            if (vector3d2.f_82480_ < (double)this.f_19793_ && (vector3d3 = this.collideBoundingBoxHeuristicallyPassable((Entity)this, new Vec3(vec.f_82479_, 0.0, vec.f_82481_), axisalignedbb.m_82383_(vector3d2), this.f_19853_, iselectioncontext, reuseablestream).m_82549_(vector3d2)).m_165925_() > vector3d1.m_165925_()) {
                vector3d1 = vector3d3;
            }
            if (vector3d1.m_165925_() > vector3d.m_165925_()) {
                return vector3d1.m_82549_(this.collideBoundingBoxHeuristicallyPassable((Entity)this, new Vec3(0.0, -vector3d1.f_82480_ + vec.f_82480_, 0.0), axisalignedbb.m_82383_(vector3d1), this.f_19853_, iselectioncontext, reuseablestream));
            }
        }
        return vector3d;
    }

    @Override
    public boolean canPassThrough(BlockPos mutablePos, BlockState blockstate, VoxelShape voxelshape) {
        return blockstate.m_60734_() == Blocks.f_50571_ || blockstate.m_60620_((Tag)BlockTags.f_13035_);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PAW_R, ANIMATION_PAW_L, ANIMATION_LEAP, ANIMATION_TAIL_FLICK};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void m_7334_(Entity entityIn) {
        if (!this.isHolding() || entityIn != this.m_5448_()) {
            super.m_7334_(entityIn);
        }
    }

    protected void m_7324_(Entity entityIn) {
        if (!this.isHolding() || entityIn != this.m_5448_()) {
            super.m_7324_(entityIn);
        }
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.m_41720_().m_41472_() && stack.m_41720_().m_41473_() != null && stack.m_41720_().m_41473_().m_38746_() && stack.m_41720_() != Items.f_42583_;
    }

    @Override
    public double getMaxDistToItem() {
        return 3.0;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.dontSitFlag = false;
        ItemStack stack = e.m_32055_();
        if (stack.m_41720_().m_41472_() && stack.m_41720_().m_41473_() != null && stack.m_41720_().m_41473_().m_38746_() && stack.m_41720_() != Items.f_42583_) {
            this.m_5496_(SoundEvents.f_11788_, this.m_6100_(), this.m_6121_());
            this.m_5634_(5.0f);
            if (e.m_32057_() != null && (double)this.f_19796_.nextFloat() < this.getChanceForEffect(stack) && this.f_19853_.m_46003_(e.m_32057_()) != null) {
                Player player = this.f_19853_.m_46003_(e.m_32057_());
                player.m_7292_(new MobEffectInstance(AMEffectRegistry.TIGERS_BLESSING, 12000));
                this.m_6710_(null);
                this.m_6703_(null);
            }
        }
    }

    @Override
    public void onFindTarget(ItemEntity e) {
        this.dontSitFlag = true;
        this.setSitting(false);
        this.setSleeping(false);
    }

    public double getChanceForEffect(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42485_ || stack.m_41720_() == Items.f_42486_) {
            return 0.4f;
        }
        if (stack.m_41720_() == Items.f_42581_ || stack.m_41720_() == Items.f_42582_) {
            return 0.3f;
        }
        return 0.1f;
    }

    protected void m_6135_() {
        if (!this.m_5803_() && !this.isSitting()) {
            super.m_6135_();
        }
    }

    private class AIMelee
    extends Goal {
        private EntityTiger tiger;
        private int jumpAttemptCooldown = 0;

        public AIMelee() {
            this.tiger = EntityTiger.this;
        }

        public boolean m_8036_() {
            return this.tiger.m_5448_() != null && this.tiger.m_5448_().m_6084_();
        }

        public void m_8037_() {
            LivingEntity target;
            if (this.jumpAttemptCooldown > 0) {
                --this.jumpAttemptCooldown;
            }
            if ((target = this.tiger.m_5448_()) != null && target.m_6084_()) {
                double dist = this.tiger.m_20270_((Entity)target);
                if (this.tiger.m_142581_() != null && this.tiger.m_142581_().m_6084_() && dist < 10.0) {
                    this.tiger.setStealth(false);
                } else if (dist > 20.0) {
                    this.tiger.setRunning(false);
                    this.tiger.setStealth(true);
                }
                if (dist <= 20.0) {
                    this.tiger.setStealth(false);
                    this.tiger.setRunning(true);
                    if (((Integer)this.tiger.f_19804_.m_135370_(LAST_SCARED_MOB_ID)).intValue() != target.m_142049_()) {
                        this.tiger.f_19804_.m_135381_(LAST_SCARED_MOB_ID, (Object)target.m_142049_());
                        target.m_7292_(new MobEffectInstance(AMEffectRegistry.FEAR, 100, 0, true, false));
                    }
                }
                if (dist < 12.0 && this.tiger.getAnimation() == IAnimatedEntity.NO_ANIMATION && this.tiger.m_20096_() && this.jumpAttemptCooldown == 0 && !this.tiger.isHolding()) {
                    this.tiger.setAnimation(ANIMATION_LEAP);
                    this.jumpAttemptCooldown = 70;
                }
                if ((this.jumpAttemptCooldown > 0 || this.tiger.m_20072_()) && !this.tiger.isHolding() && this.tiger.getAnimation() == IAnimatedEntity.NO_ANIMATION && dist < (double)(4.0f + target.m_20205_())) {
                    this.tiger.setAnimation(this.tiger.m_21187_().nextBoolean() ? ANIMATION_PAW_L : ANIMATION_PAW_R);
                }
                if (dist < (double)(4.0f + target.m_20205_()) && (this.tiger.getAnimation() == ANIMATION_PAW_L || this.tiger.getAnimation() == ANIMATION_PAW_R) && this.tiger.getAnimationTick() == 8) {
                    target.m_6469_(DamageSource.m_19370_((LivingEntity)this.tiger), (float)(7 + this.tiger.m_21187_().nextInt(5)));
                }
                if (this.tiger.getAnimation() == ANIMATION_LEAP) {
                    this.tiger.m_21573_().m_26573_();
                    Vec3 vec = target.m_20182_().m_82546_(this.tiger.m_20182_());
                    this.tiger.m_146922_(-((float)Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_)) * 57.295776f);
                    this.tiger.f_20883_ = this.tiger.m_146908_();
                    if (this.tiger.getAnimationTick() == 5 && this.tiger.f_19861_) {
                        Vec3 vector3d1 = new Vec3(target.m_20185_() - this.tiger.m_20185_(), 0.0, target.m_20189_() - this.tiger.m_20189_());
                        if (vector3d1.m_82556_() > 1.0E-7) {
                            vector3d1 = vector3d1.m_82541_().m_82490_(Math.min(dist, 15.0) * (double)0.2f);
                        }
                        this.tiger.m_20334_(vector3d1.f_82479_, vector3d1.f_82480_ + (double)0.3f + (double)0.1f * Mth.m_14008_((double)(target.m_20188_() - this.tiger.m_20186_()), (double)0.0, (double)2.0), vector3d1.f_82481_);
                    }
                    if (dist < (double)(target.m_20205_() + 3.0f) && this.tiger.getAnimationTick() >= 15) {
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this.tiger), 2.0f);
                        this.tiger.setRunning(false);
                        this.tiger.setStealth(false);
                        this.tiger.setHolding(true);
                    }
                } else if (this.tiger.isHolding()) {
                    this.tiger.m_21573_().m_26573_();
                } else {
                    try {
                        this.tiger.m_21573_().m_5624_((Entity)target, this.tiger.isStealth() ? 0.75 : 1.0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void m_8041_() {
            this.tiger.setStealth(false);
            this.tiger.setRunning(false);
            this.tiger.setHolding(false);
        }
    }

    class AngerGoal
    extends HurtByTargetGoal {
        AngerGoal(EntityTiger beeIn) {
            super((PathfinderMob)beeIn, new Class[0]);
        }

        public boolean m_8045_() {
            return EntityTiger.this.m_21660_() && super.m_8045_();
        }

        public void m_8056_() {
            super.m_8056_();
            if (EntityTiger.this.m_6162_()) {
                this.m_26047_();
                this.m_8041_();
            }
        }

        protected void m_5766_(Mob mobIn, LivingEntity targetIn) {
            if (!mobIn.m_6162_()) {
                super.m_5766_(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        public AttackPlayerGoal() {
            super((Mob)EntityTiger.this, Player.class, 100, false, true, NO_BLESSING_EFFECT);
        }

        public boolean m_8036_() {
            if (EntityTiger.this.m_6162_()) {
                return false;
            }
            return super.m_8036_();
        }

        protected double m_7623_() {
            return 4.0;
        }
    }

    class Navigator
    extends GroundPathNavigatorWide {
        public Navigator(Mob mob, Level world) {
            super(mob, world, 1.2f);
        }

        protected PathFinder m_5532_(int i) {
            this.f_26508_ = new NodeProcessor();
            return new PathFinder(this.f_26508_, i);
        }

        protected boolean m_6454_(Vec3 posVec31, Vec3 posVec32, int sizeX, int sizeY, int sizeZ) {
            int i = Mth.m_14107_((double)posVec31.f_82479_);
            int j = Mth.m_14107_((double)posVec31.f_82481_);
            double d0 = posVec32.f_82479_ - posVec31.f_82479_;
            double d1 = posVec32.f_82481_ - posVec31.f_82481_;
            double d2 = d0 * d0 + d1 * d1;
            if (d2 < 1.0E-8) {
                return false;
            }
            double d3 = 1.0 / Math.sqrt(d2);
            if (!this.isSafeToStandAt(i, Mth.m_14107_((double)posVec31.f_82480_), j, sizeX += 2, sizeY, sizeZ += 2, posVec31, d0 *= d3, d1 *= d3)) {
                return false;
            }
            sizeX -= 2;
            sizeZ -= 2;
            double d4 = 1.0 / Math.abs(d0);
            double d5 = 1.0 / Math.abs(d1);
            double d6 = (double)i - posVec31.f_82479_;
            double d7 = (double)j - posVec31.f_82481_;
            if (d0 >= 0.0) {
                d6 += 1.0;
            }
            if (d1 >= 0.0) {
                d7 += 1.0;
            }
            d6 /= d0;
            d7 /= d1;
            int k = d0 < 0.0 ? -1 : 1;
            int l = d1 < 0.0 ? -1 : 1;
            int i1 = Mth.m_14107_((double)posVec32.f_82479_);
            int j1 = Mth.m_14107_((double)posVec32.f_82481_);
            int k1 = i1 - i;
            int l1 = j1 - j;
            while (k1 * k > 0 || l1 * l > 0) {
                if (d6 < d7) {
                    d6 += d4;
                    k1 = i1 - (i += k);
                } else {
                    d7 += d5;
                    l1 = j1 - (j += l);
                }
                if (this.isSafeToStandAt(i, Mth.m_14107_((double)posVec31.f_82480_), j, sizeX, sizeY, sizeZ, posVec31, d0, d1)) continue;
                return false;
            }
            return true;
        }

        private boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3 p_179692_7_, double p_179692_8_, double p_179692_10_) {
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
                double d1;
                double d0 = (double)blockpos.m_123341_() + 0.5 - p_179692_7_.f_82479_;
                if ((d0 * p_179692_8_ + (d1 = (double)blockpos.m_123343_() + 0.5 - p_179692_7_.f_82481_) * p_179692_10_ < 0.0 || this.f_26495_.m_8055_(blockpos).m_60647_((BlockGetter)this.f_26495_, blockpos, PathComputationType.LAND)) && !EntityTiger.this.canPassThrough(blockpos, this.f_26495_.m_8055_(blockpos), null)) continue;
                return false;
            }
            return true;
        }

        private boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3 vec31, double p_179683_8_, double p_179683_10_) {
            int i = x - sizeX / 2;
            int j = z - sizeZ / 2;
            if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, vec31, p_179683_8_, p_179683_10_)) {
                return false;
            }
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int k = i; k < i + sizeX; ++k) {
                for (int l = j; l < j + sizeZ; ++l) {
                    double d0 = (double)k + 0.5 - vec31.f_82479_;
                    double d1 = (double)l + 0.5 - vec31.f_82481_;
                    if (d0 * p_179683_8_ + d1 * p_179683_10_ < 0.0) continue;
                    BlockPathTypes pathnodetype = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, k, y - 1, l, this.f_26494_, sizeX, sizeY, sizeZ, true, true);
                    mutable.m_122178_(k, y - 1, l);
                    if (!this.m_7367_(pathnodetype) || EntityTiger.this.canPassThrough((BlockPos)mutable, this.f_26495_.m_8055_((BlockPos)mutable), null)) {
                        return false;
                    }
                    pathnodetype = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, k, y, l, this.f_26494_, sizeX, sizeY, sizeZ, true, true);
                    float f = this.f_26494_.m_21439_(pathnodetype);
                    if (f < 0.0f || f >= 8.0f) {
                        return false;
                    }
                    if (pathnodetype != BlockPathTypes.DAMAGE_FIRE && pathnodetype != BlockPathTypes.DANGER_FIRE && pathnodetype != BlockPathTypes.DAMAGE_OTHER) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean m_7367_(BlockPathTypes p_230287_1_) {
            if (p_230287_1_ == BlockPathTypes.WATER) {
                return false;
            }
            if (p_230287_1_ == BlockPathTypes.LAVA) {
                return false;
            }
            return p_230287_1_ != BlockPathTypes.OPEN;
        }
    }

    static class NodeProcessor
    extends WalkNodeEvaluator {
        private NodeProcessor() {
        }

        public static BlockPathTypes getBlockPathTypeStatic(BlockGetter p_237231_0_, BlockPos.MutableBlockPos p_237231_1_) {
            int i = p_237231_1_.m_123341_();
            int j = p_237231_1_.m_123342_();
            int k = p_237231_1_.m_123343_();
            BlockPathTypes pathnodetype = NodeProcessor.getNodes(p_237231_0_, (BlockPos)p_237231_1_);
            if (pathnodetype == BlockPathTypes.OPEN && j >= 1) {
                BlockPathTypes pathnodetype1 = NodeProcessor.getNodes(p_237231_0_, (BlockPos)p_237231_1_.m_122178_(i, j - 1, k));
                BlockPathTypes blockPathTypes = pathnodetype = pathnodetype1 != BlockPathTypes.WALKABLE && pathnodetype1 != BlockPathTypes.OPEN && pathnodetype1 != BlockPathTypes.WATER && pathnodetype1 != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
                if (pathnodetype1 == BlockPathTypes.DAMAGE_FIRE) {
                    pathnodetype = BlockPathTypes.DAMAGE_FIRE;
                }
                if (pathnodetype1 == BlockPathTypes.DAMAGE_CACTUS) {
                    pathnodetype = BlockPathTypes.DAMAGE_CACTUS;
                }
                if (pathnodetype1 == BlockPathTypes.DAMAGE_OTHER) {
                    pathnodetype = BlockPathTypes.DAMAGE_OTHER;
                }
                if (pathnodetype1 == BlockPathTypes.STICKY_HONEY) {
                    pathnodetype = BlockPathTypes.STICKY_HONEY;
                }
            }
            if (pathnodetype == BlockPathTypes.WALKABLE) {
                pathnodetype = NodeProcessor.m_77607_((BlockGetter)p_237231_0_, (BlockPos.MutableBlockPos)p_237231_1_.m_122178_(i, j, k), (BlockPathTypes)pathnodetype);
            }
            return pathnodetype;
        }

        protected static BlockPathTypes getNodes(BlockGetter p_237238_0_, BlockPos p_237238_1_) {
            BlockState blockstate = p_237238_0_.m_8055_(p_237238_1_);
            BlockPathTypes type = blockstate.getAiPathNodeType(p_237238_0_, p_237238_1_);
            if (type != null) {
                return type;
            }
            Block block = blockstate.m_60734_();
            Material material = blockstate.m_60767_();
            if (blockstate.m_60795_()) {
                return BlockPathTypes.OPEN;
            }
            if (blockstate.m_60734_() == Blocks.f_50571_) {
                return BlockPathTypes.OPEN;
            }
            return NodeProcessor.m_77643_((BlockGetter)p_237238_0_, (BlockPos)p_237238_1_);
        }

        public BlockPathTypes m_8086_(BlockGetter blockaccessIn, int x, int y, int z) {
            return NodeProcessor.getBlockPathTypeStatic(blockaccessIn, new BlockPos.MutableBlockPos(x, y, z));
        }

        protected BlockPathTypes m_6603_(BlockGetter world, boolean b1, boolean b2, BlockPos pos, BlockPathTypes nodeType) {
            return nodeType == BlockPathTypes.LEAVES || world.m_8055_(pos).m_60734_() == Blocks.f_50571_ ? BlockPathTypes.OPEN : super.m_6603_(world, b1, b2, pos, nodeType);
        }
    }
}

