/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBlobfish;
import com.github.alexthe666.alexsmobs.entity.EntityFrilledShark;
import com.github.alexthe666.alexsmobs.entity.EntityLobster;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.EntityPlatypus;
import com.github.alexthe666.alexsmobs.entity.EntityStradpole;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModFishBucket
extends BucketItem {
    private final EntityType<?> fishType;
    private final Supplier<? extends EntityType<?>> fishTypeSupplier;

    public ItemModFishBucket(EntityType<?> fishTypeIn, Fluid fluid, Item.Properties builder) {
        super(fluid, builder.m_41487_(1));
        this.fishType = fishTypeIn;
        this.fishTypeSupplier = () -> fishTypeIn;
    }

    public void checkExtraContent(Level worldIn, ItemStack p_203792_2_, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            this.placeFish((ServerLevel)worldIn, p_203792_2_, pos);
        }
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor worldIn, BlockPos pos) {
        worldIn.m_5594_(player, pos, SoundEvents.f_11779_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeFish(ServerLevel worldIn, ItemStack stack, BlockPos pos) {
        CompoundTag compoundnbt;
        Entity entity = this.fishType.m_20592_(worldIn, stack, (Player)null, pos, MobSpawnType.BUCKET, true, false);
        if (entity != null && entity instanceof EntityLobster) {
            ((EntityLobster)entity).setFromBucket(true);
            compoundnbt = stack.m_41784_();
            if (compoundnbt.m_128425_("BucketVariantTag", 3)) {
                int i = compoundnbt.m_128451_("BucketVariantTag");
                ((EntityLobster)entity).setVariant(i);
            }
        }
        if (entity != null && entity instanceof EntityBlobfish) {
            ((EntityBlobfish)entity).setFromBucket(true);
            compoundnbt = stack.m_41784_();
            if (compoundnbt.m_128441_("BucketScale")) {
                ((EntityBlobfish)entity).setBlobfishScale(compoundnbt.m_128457_("BucketScale"));
            }
            if (compoundnbt.m_128441_("Slimed")) {
                ((EntityBlobfish)entity).setSlimed(compoundnbt.m_128471_("Slimed"));
            }
        }
        if (entity != null && entity instanceof EntityStradpole) {
            ((EntityStradpole)entity).setFromBucket(true);
        }
        if (entity != null && entity instanceof EntityPlatypus && (compoundnbt = stack.m_41784_()).m_128441_("PlatypusData")) {
            ((EntityPlatypus)entity).m_7378_(compoundnbt.m_128469_("PlatypusData"));
        }
        if (entity != null && entity instanceof EntityFrilledShark && (compoundnbt = stack.m_41784_()).m_128441_("FrilledSharkData")) {
            ((EntityFrilledShark)entity).m_7378_(compoundnbt.m_128469_("FrilledSharkData"));
        }
        if (entity != null && entity instanceof EntityMimicOctopus) {
            compoundnbt = stack.m_41784_();
            if (compoundnbt.m_128441_("MimicOctopusData")) {
                ((EntityMimicOctopus)entity).m_7378_(compoundnbt.m_128469_("MimicOctopusData"));
            }
            ((EntityMimicOctopus)entity).setMoistness(60000);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag compoundnbt;
        if (this.fishType == AMEntityRegistry.LOBSTER && (compoundnbt = stack.m_41783_()) != null && compoundnbt.m_128425_("BucketVariantTag", 3)) {
            int i = compoundnbt.m_128451_("BucketVariantTag");
            String s = "entity.alexsmobs.lobster.variant_" + EntityLobster.getVariantName(i);
            tooltip.add((Component)new TranslatableComponent(s).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    protected EntityType<?> getFishType() {
        return this.fishTypeSupplier.get();
    }
}

