/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

public final class NetworkChannel {
    private final class_2960 id;
    private final Map<Class<?>, MessageInfo<?>> encoders = Maps.newHashMap();

    private NetworkChannel(class_2960 id) {
        this.id = id;
    }

    public static NetworkChannel create(class_2960 id) {
        return new NetworkChannel(id);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(NetworkManager.Side side, Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(Optional<NetworkManager.Side> side, Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    public <T> void register(Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        String s = UUID.nameUUIDFromBytes(type.getName().getBytes(StandardCharsets.UTF_8)).toString().replace("-", "");
        MessageInfo info = new MessageInfo(new class_2960(this.id + "/" + s), encoder, decoder, messageConsumer);
        this.encoders.put(type, info);
        NetworkManager.NetworkReceiver receiver = (buf, context) -> info.messageConsumer.accept(info.decoder.apply(buf), () -> context);
        NetworkManager.registerReceiver(NetworkManager.c2s(), info.packetId, receiver);
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver(NetworkManager.s2c(), info.packetId, receiver);
        }
    }

    public static long hashCodeString(String str) {
        long h = 0L;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            h = 31L * h + (long)str.charAt(i);
        }
        return h;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(int id, Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(NetworkManager.Side side, int id, Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(Optional<NetworkManager.Side> side, int id, Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    public <T> class_2596<?> toPacket(NetworkManager.Side side, T message) {
        MessageInfo<?> messageInfo = Objects.requireNonNull(this.encoders.get(message.getClass()), "Unknown message type! " + message);
        class_2540 buf = new class_2540(Unpooled.buffer());
        ((MessageInfo)messageInfo).encoder.accept(message, buf);
        return NetworkManager.toPacket(side, ((MessageInfo)messageInfo).packetId, buf);
    }

    public <T> void sendToPlayer(class_3222 player, T message) {
        Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_13987.method_14364(this.toPacket(NetworkManager.s2c(), message));
    }

    public <T> void sendToPlayers(Iterable<class_3222> players, T message) {
        class_2596<?> packet = this.toPacket(NetworkManager.s2c(), message);
        for (class_3222 player : players) {
            Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_13987.method_14364(packet);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public <T> void sendToServer(T message) {
        if (class_310.method_1551().method_1562() == null) {
            throw new IllegalStateException("Unable to send packet to the server while not in game!");
        }
        class_310.method_1551().method_1562().method_2883(this.toPacket(NetworkManager.c2s(), message));
    }

    @Environment(value=EnvType.CLIENT)
    public <T> boolean canServerReceive(Class<T> type) {
        return NetworkManager.canServerReceive(((MessageInfo)this.encoders.get(type)).packetId);
    }

    public <T> boolean canPlayerReceive(class_3222 player, Class<T> type) {
        return NetworkManager.canPlayerReceive(player, ((MessageInfo)this.encoders.get(type)).packetId);
    }

    private static final class MessageInfo<T> {
        private final class_2960 packetId;
        private final BiConsumer<T, class_2540> encoder;
        private final Function<class_2540, T> decoder;
        private final BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer;

        public MessageInfo(class_2960 packetId, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
            this.packetId = packetId;
            this.encoder = encoder;
            this.decoder = decoder;
            this.messageConsumer = messageConsumer;
        }
    }
}

