/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.fabric.NetworkManagerImpl;
import dev.architectury.utils.Env;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public final class NetworkManager {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, class_2960 id, NetworkReceiver receiver) {
        void var2_2;
        void var1_1;
        NetworkManagerImpl.registerReceiver(side, (class_2960)var1_1, (NetworkReceiver)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2596<?> toPacket(Side side, class_2960 id, class_2540 buf) {
        void var2_2;
        void var1_1;
        return NetworkManagerImpl.toPacket(side, (class_2960)var1_1, (class_2540)var2_2);
    }

    public static void sendToPlayer(class_3222 player, class_2960 id, class_2540 buf) {
        Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_13987.method_14364(NetworkManager.toPacket(NetworkManager.serverToClient(), id, buf));
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_2960 id, class_2540 buf) {
        class_2596<?> packet = NetworkManager.toPacket(NetworkManager.serverToClient(), id, buf);
        for (class_3222 player : players) {
            Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_13987.method_14364(packet);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(class_2960 id, class_2540 buf) {
        if (class_310.method_1551().method_1562() == null) {
            throw new IllegalStateException("Unable to send packet to the server while not in game!");
        }
        class_310.method_1551().method_1562().method_2883(NetworkManager.toPacket(NetworkManager.clientToServer(), id, buf));
    }

    @Environment(value=EnvType.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canServerReceive(class_2960 id) {
        return NetworkManagerImpl.canServerReceive(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canPlayerReceive(class_3222 player, class_2960 id) {
        void var1_1;
        return NetworkManagerImpl.canPlayerReceive(player, (class_2960)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2596<?> createAddEntityPacket(class_1297 entity) {
        return NetworkManagerImpl.createAddEntityPacket(entity);
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    public static enum Side {
        S2C,
        C2S;

    }

    public static interface PacketContext {
        public class_1657 getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        default public EnvType getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }

    @FunctionalInterface
    public static interface NetworkReceiver {
        public void receive(class_2540 var1, PacketContext var2);
    }
}

