/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.fabric;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.fabric.SpawnEntityPacket;
import dev.architectury.utils.Env;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkManagerImpl {
    public static void registerReceiver(NetworkManager.Side side, class_2960 id, NetworkManager.NetworkReceiver receiver) {
        if (side == NetworkManager.Side.C2S) {
            NetworkManagerImpl.registerC2SReceiver(id, receiver);
        } else if (side == NetworkManager.Side.S2C) {
            NetworkManagerImpl.registerS2CReceiver(id, receiver);
        }
    }

    private static void registerC2SReceiver(class_2960 id, NetworkManager.NetworkReceiver receiver) {
        ServerSidePacketRegistry.INSTANCE.register(id, (packetContext, buf) -> receiver.receive(buf, NetworkManagerImpl.to(packetContext)));
    }

    @Environment(value=EnvType.CLIENT)
    private static void registerS2CReceiver(class_2960 id, NetworkManager.NetworkReceiver receiver) {
        ClientSidePacketRegistry.INSTANCE.register(id, (packetContext, buf) -> receiver.receive(buf, NetworkManagerImpl.to(packetContext)));
    }

    private static NetworkManager.PacketContext to(final PacketContext context) {
        return new NetworkManager.PacketContext(){

            @Override
            public class_1657 getPlayer() {
                return context.getPlayer();
            }

            @Override
            public void queue(Runnable runnable) {
                context.getTaskQueue().execute(runnable);
            }

            @Override
            public Env getEnvironment() {
                return Env.fromPlatform(context.getPacketEnvironment());
            }
        };
    }

    public static class_2596<?> toPacket(NetworkManager.Side side, class_2960 id, class_2540 buf) {
        if (side == NetworkManager.Side.C2S) {
            return NetworkManagerImpl.toC2SPacket(id, buf);
        }
        if (side == NetworkManager.Side.S2C) {
            return NetworkManagerImpl.toS2CPacket(id, buf);
        }
        throw new IllegalArgumentException("Invalid side: " + side);
    }

    public static boolean canServerReceive(class_2960 id) {
        return ClientSidePacketRegistry.INSTANCE.canServerReceive(id);
    }

    public static boolean canPlayerReceive(class_3222 player, class_2960 id) {
        return ServerSidePacketRegistry.INSTANCE.canPlayerReceive((class_1657)player, id);
    }

    public static class_2596<?> createAddEntityPacket(class_1297 entity) {
        return SpawnEntityPacket.create(entity);
    }

    @Environment(value=EnvType.CLIENT)
    private static class_2596<?> toC2SPacket(class_2960 id, class_2540 buf) {
        return ClientSidePacketRegistry.INSTANCE.toPacket(id, buf);
    }

    private static class_2596<?> toS2CPacket(class_2960 id, class_2540 buf) {
        return ServerSidePacketRegistry.INSTANCE.toPacket(id, buf);
    }
}

