/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.fabric.RegistriesImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class Registries {
    private static final Map<String, Registries> REGISTRIES = new ConcurrentHashMap<String, Registries>();
    private final RegistryProvider provider;
    private final String modId;

    public static Registries get(String modId) {
        return REGISTRIES.computeIfAbsent(modId, Registries::new);
    }

    private Registries(String modId) {
        this.provider = Registries._get(modId);
        this.modId = modId;
    }

    public <T> Registrar<T> get(class_5321<class_2378<T>> key) {
        return this.provider.get(key);
    }

    @Deprecated
    public <T> Registrar<T> get(class_2378<T> registry) {
        return this.provider.get(registry);
    }

    @SafeVarargs
    public final <T> RegistrarBuilder<T> builder(class_2960 registryId, T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        return this.provider.builder(typeGetter.getClass().getComponentType(), registryId);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> class_2960 getId(T object, @Nullable class_5321<class_2378<T>> fallback) {
        void var1_1;
        return RegistriesImpl.getId(object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> class_2960 getId(T object, @Nullable class_2378<T> fallback) {
        void var1_1;
        return RegistriesImpl.getId(object, var1_1);
    }

    @Deprecated
    @Nullable
    public static <T> class_2960 getRegistryName(T object) {
        return Registries.getId(object, (class_5321)null);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static RegistryProvider _get(String modId) {
        return RegistriesImpl._get(modId);
    }

    public String getModId() {
        return this.modId;
    }

    @ApiStatus.Internal
    public static interface RegistryProvider {
        public <T> Registrar<T> get(class_5321<class_2378<T>> var1);

        @Deprecated
        public <T> Registrar<T> get(class_2378<T> var1);

        public <T> RegistrarBuilder<T> builder(Class<T> var1, class_2960 var2);
    }
}

