/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries.fabric;

import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.Registries;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.registry.registries.options.RegistrarOption;
import dev.architectury.registry.registries.options.StandardRegistrarOption;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistriesImpl {
    public static Registries.RegistryProvider _get(String modId) {
        return RegistryProviderImpl.INSTANCE;
    }

    public static <T> class_2960 getId(T object, class_5321<class_2378<T>> fallback) {
        if (fallback == null) {
            return null;
        }
        return RegistryProviderImpl.INSTANCE.get(fallback).getId(object);
    }

    public static <T> class_2960 getId(T object, class_2378<T> fallback) {
        if (fallback == null) {
            return null;
        }
        return RegistryProviderImpl.INSTANCE.get(fallback).getId(object);
    }

    public static enum RegistryProviderImpl implements Registries.RegistryProvider
    {
        INSTANCE;


        @Override
        public <T> Registrar<T> get(class_5321<class_2378<T>> key) {
            return new RegistrarImpl((class_2378)class_2378.field_11144.method_10223(key.method_29177()));
        }

        @Override
        public <T> Registrar<T> get(class_2378<T> registry) {
            return new RegistrarImpl<T>(registry);
        }

        @Override
        @NotNull
        public <T> RegistrarBuilder<T> builder(Class<T> type, class_2960 registryId) {
            return new RegistrarBuilderWrapper(FabricRegistryBuilder.createSimple(type, (class_2960)registryId));
        }
    }

    public static class RegistrarImpl<T>
    implements Registrar<T> {
        private class_2378<T> delegate;

        public RegistrarImpl(class_2378<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public RegistrySupplier<T> delegate(final class_2960 id) {
            Supplier value = Suppliers.memoize(() -> this.get(id));
            return new RegistrySupplier<T>((java.util.function.Supplier)value){
                final /* synthetic */ java.util.function.Supplier val$value;
                {
                    this.val$value = supplier;
                }

                @Override
                @NotNull
                public class_2960 getRegistryId() {
                    return delegate.method_30517().method_29177();
                }

                @Override
                @NotNull
                public class_2960 getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return this.val$value.get();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    Object object = obj;
                    if (!(object instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)object;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @NotNull
        public <E extends T> RegistrySupplier<E> register(class_2960 id, java.util.function.Supplier<E> supplier) {
            class_2378.method_10230(this.delegate, (class_2960)id, supplier.get());
            return this.delegate(id);
        }

        @Override
        @Nullable
        public class_2960 getId(T obj) {
            return this.delegate.method_10221(obj);
        }

        @Override
        public int getRawId(T obj) {
            return this.delegate.method_10206(obj);
        }

        @Override
        public Optional<class_5321<T>> getKey(T obj) {
            return this.delegate.method_29113(obj);
        }

        @Override
        @Nullable
        public T get(class_2960 id) {
            return (T)this.delegate.method_10223(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)this.delegate.method_10200(rawId);
        }

        @Override
        public boolean contains(class_2960 id) {
            return this.delegate.method_10235().contains(id);
        }

        @Override
        public boolean containsValue(T obj) {
            return this.delegate.method_29113(obj).isPresent();
        }

        @Override
        public Set<class_2960> getIds() {
            return this.delegate.method_10235();
        }

        @Override
        public Set<Map.Entry<class_5321<T>, T>> entrySet() {
            return this.delegate.method_29722();
        }

        @Override
        public class_5321<? extends class_2378<T>> key() {
            return this.delegate.method_30517();
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }
    }

    public static class RegistrarBuilderWrapper<T>
    implements RegistrarBuilder<T> {
        @NotNull
        private FabricRegistryBuilder<T, class_2370<T>> builder;

        public RegistrarBuilderWrapper(@NotNull FabricRegistryBuilder<T, class_2370<T>> builder) {
            this.builder = builder;
        }

        @Override
        @NotNull
        public Registrar<T> build() {
            return RegistryProviderImpl.INSTANCE.get(this.builder.buildAndRegister());
        }

        @Override
        @NotNull
        public RegistrarBuilder<T> option(@NotNull RegistrarOption option) {
            if (option == StandardRegistrarOption.SAVE_TO_DISC) {
                this.builder.attribute(RegistryAttribute.PERSISTED);
            } else if (option == StandardRegistrarOption.SYNC_TO_CLIENTS) {
                this.builder.attribute(RegistryAttribute.SYNCED);
            }
            return this;
        }
    }
}

