/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.forge.NetworkManagerImpl;
import dev.architectury.utils.Env;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class NetworkManager {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, ResourceLocation id, NetworkReceiver receiver) {
        void var2_2;
        void var1_1;
        NetworkManagerImpl.registerReceiver(side, (ResourceLocation)var1_1, (NetworkReceiver)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<?> toPacket(Side side, ResourceLocation id, FriendlyByteBuf buf) {
        void var2_2;
        void var1_1;
        return NetworkManagerImpl.toPacket(side, (ResourceLocation)var1_1, (FriendlyByteBuf)var2_2);
    }

    public static void sendToPlayer(ServerPlayer player, ResourceLocation id, FriendlyByteBuf buf) {
        Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").f_8906_.m_141995_(NetworkManager.toPacket(NetworkManager.serverToClient(), id, buf));
    }

    public static void sendToPlayers(Iterable<ServerPlayer> players, ResourceLocation id, FriendlyByteBuf buf) {
        Packet<?> packet = NetworkManager.toPacket(NetworkManager.serverToClient(), id, buf);
        for (ServerPlayer player : players) {
            Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").f_8906_.m_141995_(packet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation id, FriendlyByteBuf buf) {
        if (Minecraft.m_91087_().m_91403_() == null) {
            throw new IllegalStateException("Unable to send packet to the server while not in game!");
        }
        Minecraft.m_91087_().m_91403_().m_104955_(NetworkManager.toPacket(NetworkManager.clientToServer(), id, buf));
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canServerReceive(ResourceLocation id) {
        return NetworkManagerImpl.canServerReceive(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canPlayerReceive(ServerPlayer player, ResourceLocation id) {
        void var1_1;
        return NetworkManagerImpl.canPlayerReceive(player, (ResourceLocation)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<?> createAddEntityPacket(Entity entity) {
        return NetworkManagerImpl.createAddEntityPacket(entity);
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    public static enum Side {
        S2C,
        C2S;

    }

    public static interface PacketContext {
        public Player getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        default public Dist getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }

    @FunctionalInterface
    public static interface NetworkReceiver {
        public void receive(FriendlyByteBuf var1, PacketContext var2);
    }
}

