/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.core.fluid;

import com.google.common.base.MoreObjects;
import com.google.common.base.Suppliers;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.core.fluid.ArchitecturyFluidAttributesForge;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.NotNull;

public abstract class ArchitecturyFlowingFluid
extends ForgeFlowingFluid {
    private final ArchitecturyFluidAttributes attributes;
    private final Supplier<FluidType> forgeType;

    ArchitecturyFlowingFluid(ArchitecturyFluidAttributes attributes) {
        super(ArchitecturyFlowingFluid.toForgeProperties(attributes));
        this.attributes = attributes;
        this.forgeType = Suppliers.memoize(() -> new ArchitecturyFluidAttributesForge(FluidType.Properties.create(), (Fluid)this, attributes));
    }

    private static ForgeFlowingFluid.Properties toForgeProperties(ArchitecturyFluidAttributes attributes) {
        ForgeFlowingFluid.Properties forge = new ForgeFlowingFluid.Properties((Supplier)Suppliers.memoize(() -> new ArchitecturyFluidAttributesForge(FluidType.Properties.create(), attributes.getSourceFluid(), attributes)), attributes::getSourceFluid, attributes::getFlowingFluid);
        forge.slopeFindDistance(attributes.getSlopeFindDistance());
        forge.levelDecreasePerBlock(attributes.getDropOff());
        forge.bucket(() -> (Item)MoreObjects.firstNonNull((Object)attributes.getBucketItem(), (Object)Items.f_41852_));
        forge.tickRate(attributes.getTickDelay());
        forge.explosionResistance(attributes.getExplosionResistance());
        forge.block(() -> (LiquidBlock)MoreObjects.firstNonNull((Object)attributes.getBlock(), (Object)((LiquidBlock)Blocks.f_49990_)));
        return forge;
    }

    public FluidType getFluidType() {
        return this.forgeType.get();
    }

    public Fluid m_5615_() {
        return this.attributes.getFlowingFluid();
    }

    public Fluid m_5613_() {
        return this.attributes.getSourceFluid();
    }

    protected boolean m_6760_() {
        return this.attributes.canConvertToSource();
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected int m_6719_(LevelReader level) {
        return this.attributes.getSlopeFindDistance(level);
    }

    protected int m_6713_(LevelReader level) {
        return this.attributes.getDropOff(level);
    }

    public Item m_6859_() {
        Item item = this.attributes.getBucketItem();
        return item == null ? Items.f_41852_ : item;
    }

    protected boolean m_5486_(FluidState state, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluid);
    }

    public int m_6718_(LevelReader level) {
        return this.attributes.getTickDelay(level);
    }

    protected float m_6752_() {
        return this.attributes.getExplosionResistance();
    }

    protected BlockState m_5804_(FluidState state) {
        LiquidBlock block = this.attributes.getBlock();
        if (block == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return (BlockState)block.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(ArchitecturyFlowingFluid.m_76092_((FluidState)state)));
    }

    @NotNull
    public Optional<SoundEvent> m_142520_() {
        return Optional.ofNullable(this.attributes.getFillSound());
    }

    public boolean m_6212_(Fluid fluid) {
        return fluid == this.m_5613_() || fluid == this.m_5615_();
    }

    public static class Flowing
    extends ArchitecturyFlowingFluid {
        public Flowing(ArchitecturyFluidAttributes attributes) {
            super(attributes);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends ArchitecturyFlowingFluid {
        public Source(ArchitecturyFluidAttributes attributes) {
            super(attributes);
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }
}

