/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage;

import com.grim3212.assorted.storage.client.data.StorageBlockstateProvider;
import com.grim3212.assorted.storage.client.data.StorageItemModelProvider;
import com.grim3212.assorted.storage.client.proxy.ClientProxy;
import com.grim3212.assorted.storage.common.block.StorageBlocks;
import com.grim3212.assorted.storage.common.block.blockentity.StorageBlockEntityTypes;
import com.grim3212.assorted.storage.common.data.StorageBlockTagProvider;
import com.grim3212.assorted.storage.common.data.StorageItemTagProvider;
import com.grim3212.assorted.storage.common.data.StorageLootProvider;
import com.grim3212.assorted.storage.common.data.StorageRecipes;
import com.grim3212.assorted.storage.common.inventory.StorageContainerTypes;
import com.grim3212.assorted.storage.common.network.PacketHandler;
import com.grim3212.assorted.storage.common.proxy.IProxy;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="assortedstorage")
public class AssortedStorage {
    public static final String MODID = "assortedstorage";
    public static final Logger LOGGER = LogManager.getLogger((String)"assortedstorage");
    public static IProxy proxy = new IProxy(){};
    public static final CreativeModeTab ASSORTED_STORAGE_ITEM_GROUP = new CreativeModeTab("assortedstorage"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)StorageBlocks.WOOD_CABINET.get());
        }
    };

    public AssortedStorage() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            proxy = new ClientProxy();
        });
        proxy.starting();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::gatherData);
        StorageBlocks.BLOCKS.register(modBus);
        StorageBlocks.ITEMS.register(modBus);
        StorageBlockEntityTypes.BLOCK_ENTITIES.register(modBus);
        StorageContainerTypes.CONTAINERS.register(modBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator datagenerator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            datagenerator.m_123914_((DataProvider)new StorageRecipes(datagenerator));
            StorageBlockTagProvider blockTagProvider = new StorageBlockTagProvider(datagenerator, fileHelper);
            datagenerator.m_123914_((DataProvider)blockTagProvider);
            datagenerator.m_123914_((DataProvider)new StorageItemTagProvider(datagenerator, blockTagProvider, fileHelper));
            datagenerator.m_123914_((DataProvider)new StorageLootProvider(datagenerator));
        }
        if (event.includeClient()) {
            datagenerator.m_123914_((DataProvider)new StorageBlockstateProvider(datagenerator, fileHelper));
            datagenerator.m_123914_((DataProvider)new StorageItemModelProvider(datagenerator, fileHelper));
        }
    }
}

