/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.client.blockentity;

import com.grim3212.assorted.storage.client.model.StorageModelLayers;
import com.grim3212.assorted.storage.client.model.WarehouseCrateModel;
import com.grim3212.assorted.storage.common.block.BaseStorageBlock;
import com.grim3212.assorted.storage.common.block.WarehouseCrateBlock;
import com.grim3212.assorted.storage.common.block.blockentity.WarehouseCrateBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;

public class WarehouseCrateBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final WarehouseCrateModel model;
    private static final ResourceLocation OAK = new ResourceLocation("assortedstorage", "textures/model/warehouse_crate/oak.png");
    private static final ResourceLocation BIRCH = new ResourceLocation("assortedstorage", "textures/model/warehouse_crate/birch.png");
    private static final ResourceLocation SPRUCE = new ResourceLocation("assortedstorage", "textures/model/warehouse_crate/spruce.png");
    private static final ResourceLocation ACACIA = new ResourceLocation("assortedstorage", "textures/model/warehouse_crate/acacia.png");
    private static final ResourceLocation DARK_OAK = new ResourceLocation("assortedstorage", "textures/model/warehouse_crate/dark_oak.png");
    private static final ResourceLocation JUNGLE = new ResourceLocation("assortedstorage", "textures/model/warehouse_crate/jungle.png");
    private static final ResourceLocation WARPED = new ResourceLocation("assortedstorage", "textures/model/warehouse_crate/warped.png");
    private static final ResourceLocation CRIMSON = new ResourceLocation("assortedstorage", "textures/model/warehouse_crate/crimson.png");

    public WarehouseCrateBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new WarehouseCrateModel(context.m_173585_().m_171103_(StorageModelLayers.WAREHOUSE_CRATE));
    }

    public void m_6922_(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        WarehouseCrateBlockEntity tileEntity = (WarehouseCrateBlockEntity)tileEntityIn;
        Level world = tileEntity.m_58904_();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntity.m_58900_() : (BlockState)tileEntity.m_58900_().m_61124_((Property)BaseStorageBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockstate.m_60734_();
        if (block instanceof WarehouseCrateBlock) {
            WarehouseCrateBlock crate = (WarehouseCrateBlock)block;
            matrixStackIn.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)BaseStorageBlock.FACING)).m_122435_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
            float angle = tileEntity.getRotation(partialTicks);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(this.getTexture(crate.getWoodType())));
            this.model.doorAngle = angle *= 90.0f;
            this.model.renderHandle = !tileEntity.isLocked();
            this.model.handleRotations();
            this.model.m_7695_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
        }
    }

    private ResourceLocation getTexture(WoodType wood) {
        switch (wood.m_61846_()) {
            case "oak": {
                return OAK;
            }
            case "birch": {
                return BIRCH;
            }
            case "spruce": {
                return SPRUCE;
            }
            case "acacia": {
                return ACACIA;
            }
            case "dark_oak": {
                return DARK_OAK;
            }
            case "jungle": {
                return JUNGLE;
            }
            case "crimson": {
                return CRIMSON;
            }
            case "warped": {
                return WARPED;
            }
        }
        return OAK;
    }
}

