/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.client.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class ItemTowerModel
extends Model {
    public boolean topBlock = false;
    public boolean bottomBlock = false;
    public double nextRender = 0.0;
    public int frame = 0;
    public boolean framedir = false;
    public int FramesCount = 100;
    public float[] BlankFrames = new float[100];
    public float[] TopSectionFramesY = new float[100];
    public float[] TopSectionFramesZ = new float[100];
    public float[] MidSectionFramesY = new float[100];
    public float[] MidSectionFramesZ = new float[100];
    public float[] BottomSectionFramesY = new float[100];
    public float[] BottomSectionFramesZ = new float[100];
    private final ModelPart main;
    private final ModelPart posts;
    private final ModelPart cap1;
    private final ModelPart cap2;
    private final ModelPart shelf1;
    private final ModelPart shelf2;
    private final ModelPart shelf3;
    private final ModelPart shelf4;
    private final ModelPart[] sidebars;
    private final ModelPart[] midbars;

    public ItemTowerModel(ModelPart root) {
        super(RenderType::m_110452_);
        int i;
        this.main = root.m_171324_("main");
        this.posts = root.m_171324_("posts");
        this.cap1 = root.m_171324_("cap1");
        this.cap2 = root.m_171324_("cap2");
        this.shelf1 = root.m_171324_("shelf_1");
        this.shelf2 = root.m_171324_("shelf_2");
        this.shelf3 = root.m_171324_("shelf_3");
        this.shelf4 = root.m_171324_("shelf_4");
        this.sidebars = new ModelPart[8];
        ModelPart sidebarRoot = root.m_171324_("sidebars");
        for (int i2 = 1; i2 <= 8; ++i2) {
            this.sidebars[i2 - 1] = sidebarRoot.m_171324_("sidebar" + i2);
        }
        this.midbars = new ModelPart[5];
        ModelPart midbarRoot = root.m_171324_("midbars");
        for (int i3 = 1; i3 <= 5; ++i3) {
            this.midbars[i3 - 1] = midbarRoot.m_171324_("midbar" + i3);
        }
        ArrayList bottomy = Lists.newArrayList();
        ArrayList bottomz = Lists.newArrayList();
        ArrayList midy = Lists.newArrayList();
        ArrayList midz = Lists.newArrayList();
        ArrayList topy = Lists.newArrayList();
        ArrayList topz = Lists.newArrayList();
        float height = 0.0f;
        float length = 0.0f;
        for (i = 0; i < 100; ++i) {
            height = (float)i - 50.0f;
            height /= 50.0f;
            height = Math.abs(height);
            height = 1.0f - height;
            midy.add(Float.valueOf(height * 13.0f));
            if (i < 50) {
                midz.add(Float.valueOf(10.0f));
                continue;
            }
            midz.add(Float.valueOf(3.0f));
        }
        for (i = 0; i < 100; ++i) {
            height = (float)i - 50.0f;
            height /= 50.0f;
            height = Math.abs(height);
            height = 1.0f - height;
            topy.add(Float.valueOf(height * 13.0f));
            if (i < 30) {
                topz.add(Float.valueOf(10.0f));
            }
            if (i >= 30 && i <= 70) {
                length = i - 30;
                topz.add(Float.valueOf(10.0f - (length /= 40.0f) * 7.0f));
            }
            if (i <= 70) continue;
            topz.add(Float.valueOf(3.0f));
        }
        for (i = 0; i < 100; ++i) {
            height = (float)i - 50.0f;
            height /= 50.0f;
            height = Math.abs(height);
            bottomy.add(Float.valueOf(height * 13.0f));
            if (i < 30) {
                bottomz.add(Float.valueOf(3.0f));
            }
            if (i >= 30 && i <= 70) {
                length = i - 30;
                bottomz.add(Float.valueOf(3.0f + (length /= 40.0f) * 7.0f));
            }
            if (i <= 70) continue;
            bottomz.add(Float.valueOf(10.0f));
        }
        for (i = 0; i < this.FramesCount; ++i) {
            this.BottomSectionFramesY[i] = ((Float)bottomy.get(i)).floatValue();
            this.BottomSectionFramesZ[i] = ((Float)bottomz.get(i)).floatValue();
            this.MidSectionFramesY[i] = ((Float)midy.get(i)).floatValue();
            this.MidSectionFramesZ[i] = ((Float)midz.get(i)).floatValue();
            this.TopSectionFramesY[i] = ((Float)topy.get(i)).floatValue();
            this.TopSectionFramesZ[i] = ((Float)topz.get(i)).floatValue();
        }
    }

    public static LayerDefinition createBaseMeshDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition maindefinition = partdefinition.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        maindefinition.m_171599_("mainAlt", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(16.01f, 16.01f, 16.01f, -16.0f, -16.0f, -16.0f), PartPose.f_171404_);
        partdefinition.m_171599_("cap1", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f), PartPose.f_171404_);
        partdefinition.m_171599_("cap2", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(0.0f, 15.0f, 0.0f, 16.0f, 1.0f, 16.0f), PartPose.f_171404_);
        PartDefinition postsdefinition = partdefinition.m_171599_("posts", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        postsdefinition.m_171599_("post1", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 16.0f, 3.0f), PartPose.f_171404_);
        postsdefinition.m_171599_("post2", CubeListBuilder.m_171558_().m_171514_(12, 80).m_171481_(0.0f, 0.0f, 13.0f, 3.0f, 16.0f, 3.0f), PartPose.f_171404_);
        postsdefinition.m_171599_("post3", CubeListBuilder.m_171558_().m_171514_(0, 99).m_171481_(13.0f, 0.0f, 0.0f, 3.0f, 16.0f, 3.0f), PartPose.f_171404_);
        postsdefinition.m_171599_("post4", CubeListBuilder.m_171558_().m_171514_(12, 99).m_171481_(13.0f, 0.0f, 13.0f, 3.0f, 16.0f, 3.0f), PartPose.f_171404_);
        PartDefinition sidebarsdefinition = partdefinition.m_171599_("sidebars", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        sidebarsdefinition.m_171599_("sidebar1", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(3.0f, 0.0f, 0.0f, 10.0f, 1.0f, 1.0f), PartPose.f_171404_);
        sidebarsdefinition.m_171599_("sidebar2", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(0.0f, 0.0f, 3.0f, 1.0f, 1.0f, 10.0f), PartPose.f_171404_);
        sidebarsdefinition.m_171599_("sidebar3", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(3.0f, 0.0f, 15.0f, 10.0f, 1.0f, 1.0f), PartPose.f_171404_);
        sidebarsdefinition.m_171599_("sidebar4", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(15.0f, 0.0f, 3.0f, 1.0f, 1.0f, 10.0f), PartPose.f_171404_);
        sidebarsdefinition.m_171599_("sidebar5", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(3.0f, 15.0f, 0.0f, 10.0f, 1.0f, 1.0f), PartPose.f_171404_);
        sidebarsdefinition.m_171599_("sidebar6", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(0.0f, 15.0f, 3.0f, 1.0f, 1.0f, 10.0f), PartPose.f_171404_);
        sidebarsdefinition.m_171599_("sidebar7", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(3.0f, 15.0f, 15.0f, 10.0f, 1.0f, 1.0f), PartPose.f_171404_);
        sidebarsdefinition.m_171599_("sidebar8", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(15.0f, 15.0f, 3.0f, 1.0f, 1.0f, 10.0f), PartPose.f_171404_);
        PartDefinition midbarsdefinition = partdefinition.m_171599_("midbars", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        midbarsdefinition.m_171599_("midbar1", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171481_(0.0f, 7.0f, 7.0f, 16.0f, 2.0f, 2.0f), PartPose.f_171404_);
        midbarsdefinition.m_171599_("midbar2", CubeListBuilder.m_171558_().m_171514_(48, 32).m_171481_(6.0f, 0.0f, 6.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        midbarsdefinition.m_171599_("midbar3", CubeListBuilder.m_171558_().m_171514_(48, 32).m_171481_(6.0f, 0.0f, 6.0f, 4.0f, 16.0f, 4.0f), PartPose.f_171404_);
        midbarsdefinition.m_171599_("midbar4", CubeListBuilder.m_171558_().m_171514_(48, 32).m_171481_(6.0f, 4.0f, 6.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        midbarsdefinition.m_171599_("midbar5", CubeListBuilder.m_171558_().m_171514_(48, 32).m_171481_(6.0f, 1.0f, 6.0f, 4.0f, 14.0f, 4.0f), PartPose.f_171404_);
        ItemTowerModel.makeShelf(partdefinition, 1);
        ItemTowerModel.makeShelf(partdefinition, 2);
        ItemTowerModel.makeShelf(partdefinition, 3);
        ItemTowerModel.makeShelf(partdefinition, 4);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private static void makeShelf(PartDefinition partdefinition, int shelfNum) {
        PartDefinition shelf = partdefinition.m_171599_("shelf_" + shelfNum, CubeListBuilder.m_171558_().m_171514_(0, 64).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 1.0f, 3.0f), PartPose.f_171404_);
        shelf.m_171599_("shelf_part2", CubeListBuilder.m_171558_().m_171514_(0, 68).m_171481_(1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 3.0f), PartPose.f_171404_);
        shelf.m_171599_("shelf_part3", CubeListBuilder.m_171558_().m_171514_(0, 68).m_171481_(14.0f, 1.0f, 0.0f, 1.0f, 1.0f, 3.0f), PartPose.f_171404_);
        shelf.m_171599_("shelf_part4", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171481_(2.0f, 1.0f, 0.0f, 12.0f, 1.0f, 1.0f), PartPose.f_171404_);
        shelf.m_171599_("shelf_part5", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171481_(2.0f, 1.0f, 2.0f, 12.0f, 1.0f, 1.0f), PartPose.f_171404_);
    }

    public void renderModelInventory(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.main.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.posts.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.cap1.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.cap2.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.midbars[0].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.midbars[4].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.bottomBlock && this.topBlock) {
            this.main.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.midbars[0].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.midbars[2].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        if (!this.bottomBlock && !this.topBlock) {
            this.main.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.midbars[0].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.midbars[4].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        if (this.bottomBlock && this.topBlock) {
            for (ModelPart model : this.sidebars) {
                model.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
        if (this.bottomBlock && !this.topBlock) {
            this.sidebars[0].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.sidebars[1].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.sidebars[2].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.sidebars[3].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.midbars[1].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        if (!this.bottomBlock && this.topBlock) {
            this.sidebars[4].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.sidebars[5].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.sidebars[6].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.sidebars[7].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.midbars[3].m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        this.posts.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (!this.bottomBlock) {
            this.cap1.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        if (!this.topBlock) {
            this.cap2.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        this.processFrame(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setAnimation(int animation) {
        if (animation > 0) {
            this.framedir = true;
            this.frame = 0;
        }
        if (animation < 0) {
            this.framedir = false;
            this.frame = 25;
        }
    }

    public void processFrame(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if ((double)System.currentTimeMillis() > this.nextRender && (this.topBlock || this.bottomBlock)) {
            if (this.framedir) {
                if (this.frame < 25) {
                    ++this.frame;
                }
            } else if (this.frame > 0) {
                --this.frame;
            }
        }
        this.renderFramePosition(this.shelf1, this.frame, 5, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderFramePosition(this.shelf2, this.frame, 30, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderFramePosition(this.shelf3, this.frame, 55, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderFramePosition(this.shelf4, this.frame, 80, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.nextRender = (double)System.currentTimeMillis() + 1.0;
    }

    public void renderFramePosition(ModelPart model, int frame, int i, PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        int i2 = frame;
        i2 += i;
        while (i2 > 100) {
            i2 -= 100;
        }
        if (i2 > 0) {
            --i2;
        }
        float x = 0.0f;
        float y = this.getFrameYTable()[i2] / 16.0f;
        float z = this.getFrameZTable()[i2] / 16.0f;
        matrixStackIn.m_85837_((double)x, (double)y, (double)z);
        model.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.m_85837_((double)(-x), (double)(-y), (double)(-z));
    }

    public float[] getFrameYTable() {
        if (this.topBlock && !this.bottomBlock) {
            return this.BottomSectionFramesY;
        }
        if (!this.topBlock && this.bottomBlock) {
            return this.TopSectionFramesY;
        }
        if (this.topBlock && this.bottomBlock || !this.topBlock && !this.bottomBlock) {
            return this.MidSectionFramesY;
        }
        return this.BlankFrames;
    }

    public float[] getFrameZTable() {
        if (this.topBlock && !this.bottomBlock) {
            return this.BottomSectionFramesZ;
        }
        if (!this.topBlock && this.bottomBlock) {
            return this.TopSectionFramesZ;
        }
        if (this.topBlock && this.bottomBlock || !this.topBlock && !this.bottomBlock) {
            return this.MidSectionFramesZ;
        }
        return this.BlankFrames;
    }
}

