/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.blockentity.BaseStorageBlockEntity;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public abstract class BaseStorageBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape FAKE_SIDES_AND_BOTTOM = Block.m_49796_((double)0.01, (double)0.01, (double)0.01, (double)16.0, (double)16.0, (double)16.0);

    public BaseStorageBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60913_(3.0f, 5.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (context == CollisionContext.m_82749_()) {
            return FAKE_SIDES_AND_BOTTOM;
        }
        return super.m_5940_(state, worldIn, pos, context);
    }

    protected boolean isInvalidBlock(LevelAccessor world, BlockPos pos) {
        return !world.m_46859_(pos) && world.m_8055_(pos).m_60804_((BlockGetter)world, pos);
    }

    protected boolean isDoorBlocked(LevelAccessor world, BlockPos pos) {
        return this.isInvalidBlock(world, pos.m_142300_((Direction)world.m_8055_(pos).m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        BaseStorageBlockEntity tileentity;
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof BaseStorageBlockEntity && (tileentity = (BaseStorageBlockEntity)te).isLocked() && !this.canAccess(worldIn, pos, player)) {
            return -1.0f;
        }
        return super.m_5880_(state, player, worldIn, pos);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof BaseStorageBlockEntity && stack.m_41788_()) {
            ((BaseStorageBlockEntity)tileentity).setCustomName(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof BaseStorageBlockEntity) {
                BaseStorageBlockEntity teStorage = (BaseStorageBlockEntity)tileentity;
                if (teStorage.isLocked()) {
                    ItemStack lockStack = new ItemStack((ItemLike)StorageItems.LOCKSMITH_LOCK.get());
                    CompoundTag tag = new CompoundTag();
                    new StorageLockCode(teStorage.getLockCode()).write(tag);
                    lockStack.m_41751_(tag);
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)lockStack);
                }
                Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((BaseStorageBlockEntity)tileentity));
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    protected boolean canBeLocked(Level worldIn, BlockPos pos) {
        return !((BaseStorageBlockEntity)worldIn.m_7702_(pos)).isLocked();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        MenuProvider inamedcontainerprovider;
        BaseStorageBlockEntity teStorage;
        BlockEntity tileentity;
        if (this.canBeLocked(worldIn, pos) && player.m_21120_(handIn).m_41720_() == StorageItems.LOCKSMITH_LOCK.get() && this.tryPlaceLock(worldIn, pos, player, handIn)) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && this.canAccess((BlockGetter)worldIn, pos, player) && (tileentity = worldIn.m_7702_(pos)) instanceof BaseStorageBlockEntity && (teStorage = (BaseStorageBlockEntity)worldIn.m_7702_(pos)).isLocked()) {
            ItemStack lockStack = new ItemStack((ItemLike)StorageItems.LOCKSMITH_LOCK.get());
            CompoundTag tag = new CompoundTag();
            new StorageLockCode(teStorage.getLockCode()).write(tag);
            lockStack.m_41751_(tag);
            if (this.removeLock(worldIn, pos, player)) {
                ItemEntity blockDropped = new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), lockStack);
                if (!worldIn.f_46443_) {
                    worldIn.m_7967_((Entity)blockDropped);
                    if (!(player instanceof FakePlayer)) {
                        blockDropped.m_6123_(player);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (!this.isDoorBlocked((LevelAccessor)worldIn, pos) && this.canAccess((BlockGetter)worldIn, pos, player) && !worldIn.f_46443_ && (inamedcontainerprovider = this.m_7246_(state, worldIn, pos)) != null) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)inamedcontainerprovider, (BlockPos)pos);
            player.m_36246_(this.getOpenStat());
        }
        return InteractionResult.SUCCESS;
    }

    protected Stat<ResourceLocation> getOpenStat() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12968_);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity instanceof MenuProvider ? (MenuProvider)tileentity : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            BlockEntity storage$temp = t;
            if (storage$temp instanceof BaseStorageBlockEntity) {
                BaseStorageBlockEntity storage = (BaseStorageBlockEntity)storage$temp;
                storage.tick();
            }
        };
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        super.m_8133_(state, worldIn, pos, id, param);
        BlockEntity tileentity = worldIn.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38938_((Container)((Container)worldIn.m_7702_(pos)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    private boolean removeLock(Level worldIn, BlockPos pos, Player entityplayer) {
        BaseStorageBlockEntity tileentity = (BaseStorageBlockEntity)worldIn.m_7702_(pos);
        tileentity.setLockCode("");
        tileentity.m_58904_().m_5594_(entityplayer, tileentity.m_58899_(), SoundEvents.f_11748_, SoundSource.BLOCKS, 0.5f, tileentity.m_58904_().f_46441_.nextFloat() * 0.1f + 0.9f);
        return true;
    }

    private boolean tryPlaceLock(Level worldIn, BlockPos pos, Player entityplayer, InteractionHand hand) {
        BaseStorageBlockEntity tileentity = (BaseStorageBlockEntity)worldIn.m_7702_(pos);
        ItemStack itemstack = entityplayer.m_21120_(hand);
        if (itemstack.m_41782_()) {
            String code;
            String string = code = itemstack.m_41783_().m_128425_("Storage_Lock", 8) ? itemstack.m_41783_().m_128461_("Storage_Lock") : "";
            if (!code.isEmpty()) {
                if (!entityplayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                tileentity.setLockCode(code);
                tileentity.m_58904_().m_5594_(entityplayer, tileentity.m_58899_(), SoundEvents.f_11748_, SoundSource.BLOCKS, 0.5f, tileentity.m_58904_().f_46441_.nextFloat() * 0.1f + 0.9f);
                return true;
            }
        }
        return false;
    }

    private boolean canAccess(BlockGetter worldIn, BlockPos pos, Player entityplayer) {
        BaseStorageBlockEntity tileentity = (BaseStorageBlockEntity)worldIn.m_7702_(pos);
        if (tileentity.isLocked()) {
            for (int slot = 0; slot < entityplayer.m_150109_().m_6643_(); ++slot) {
                String code;
                ItemStack itemstack = entityplayer.m_150109_().m_8020_(slot);
                if (itemstack.m_41619_() || itemstack.m_41720_() != StorageItems.LOCKSMITH_KEY.get() || !itemstack.m_41782_()) continue;
                String string = code = itemstack.m_41783_().m_128425_("Storage_Lock", 8) ? itemstack.m_41783_().m_128461_("Storage_Lock") : "";
                if (code.isEmpty()) continue;
                return tileentity.getLockCode().equals(code);
            }
            return false;
        }
        return true;
    }
}

