/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.BaseStorageBlock;
import com.grim3212.assorted.storage.common.block.ObsidianSafeBlock;
import com.grim3212.assorted.storage.common.block.StorageBlocks;
import com.grim3212.assorted.storage.common.block.blockentity.GoldSafeBlockEntity;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GoldSafeBlock
extends BaseStorageBlock {
    public static final ResourceLocation CONTENTS = new ResourceLocation("assortedstorage", "contents");

    public GoldSafeBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60999_().m_60913_(50.0f, 1200.0f));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GoldSafeBlockEntity(pos, state);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ObsidianSafeBlock.SAFE_SHAPE;
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof GoldSafeBlockEntity) {
                GoldSafeBlockEntity goldsafetileentity = (GoldSafeBlockEntity)tileentity;
                if (goldsafetileentity.isLocked()) {
                    ItemStack lockStack = new ItemStack((ItemLike)StorageItems.LOCKSMITH_LOCK.get());
                    CompoundTag tag = new CompoundTag();
                    new StorageLockCode(goldsafetileentity.getLockCode()).write(tag);
                    lockStack.m_41751_(tag);
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)lockStack);
                }
                worldIn.m_46717_(pos, state.m_60734_());
            }
            if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
                worldIn.m_46747_(pos);
            }
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.m_7397_(worldIn, pos, state);
        GoldSafeBlockEntity goldsafetileentity = (GoldSafeBlockEntity)worldIn.m_7702_(pos);
        CompoundTag compoundnbt = goldsafetileentity.saveToNbt(new CompoundTag());
        if (!compoundnbt.m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
        }
        return itemstack;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof GoldSafeBlockEntity) {
            GoldSafeBlockEntity goldsafetileentity = (GoldSafeBlockEntity)tileentity;
            if (!worldIn.f_46443_ && player.m_7500_() && !goldsafetileentity.m_7983_()) {
                ItemStack itemstack = new ItemStack((ItemLike)StorageBlocks.GOLD_SAFE.get());
                CompoundTag compoundnbt = goldsafetileentity.saveToNbt(new CompoundTag());
                if (!compoundnbt.m_128456_()) {
                    itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
                }
                if (goldsafetileentity.m_8077_()) {
                    itemstack.m_41714_(goldsafetileentity.m_7770_());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                worldIn.m_7967_((Entity)itementity);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tileentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tileentity instanceof GoldSafeBlockEntity) {
            GoldSafeBlockEntity goldsafetileentity = (GoldSafeBlockEntity)tileentity;
            builder = builder.m_78979_(CONTENTS, (context, stackConsumer) -> {
                for (int i = 0; i < goldsafetileentity.m_6643_(); ++i) {
                    stackConsumer.accept(goldsafetileentity.m_8020_(i));
                }
            });
        }
        return super.m_7381_(state, builder);
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        CompoundTag compoundnbt = stack.m_41737_("BlockEntityTag");
        if (compoundnbt != null) {
            if (compoundnbt.m_128425_("LootTable", 8)) {
                tooltip.add((Component)new TextComponent("???????"));
            }
            if (compoundnbt.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent iformattabletextcomponent = itemstack.m_41786_().m_6881_();
                    iformattabletextcomponent.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                    tooltip.add((Component)iformattabletextcomponent);
                }
                if (j - i > 0) {
                    tooltip.add((Component)new TranslatableComponent("container.shulkerBox.more", new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }
}

