/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.blockentity.BaseLockedBlockEntity;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class LockedDoorBlock
extends DoorBlock
implements EntityBlock {
    private final Block parent;

    public LockedDoorBlock(Block parent, BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52726_, (Comparable)Direction.NORTH)).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52728_, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER));
        this.parent = parent;
    }

    public LockedDoorBlock(ResourceLocation parent, BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52726_, (Comparable)Direction.NORTH)).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52728_, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER));
        this.parent = (Block)Registry.f_122824_.m_7745_(parent);
    }

    public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.parent.getPickBlock(state, target, world, pos, player);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public void m_153165_(Entity entity, Level worldIn, BlockState state, BlockPos pos, boolean open) {
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_((Property)f_52730_);
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            boolean isValidBlock;
            boolean bl = isValidBlock = doubleblockhalf == DoubleBlockHalf.UPPER ? worldIn.m_8055_(currentPos.m_7495_()).m_60734_() instanceof DoorBlock : worldIn.m_8055_(currentPos.m_7494_()).m_60734_() instanceof DoorBlock;
            return facingState.m_60713_((Block)this) && facingState.m_61143_((Property)f_52730_) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)f_52726_, (Comparable)((Direction)facingState.m_61143_((Property)f_52726_)))).m_61124_((Property)f_52727_, (Comparable)((Boolean)facingState.m_61143_((Property)f_52727_)))).m_61124_((Property)f_52728_, (Comparable)((DoorHingeSide)facingState.m_61143_((Property)f_52728_)))).m_61124_((Property)f_52729_, (Comparable)((Boolean)facingState.m_61143_((Property)f_52729_))) : (isValidBlock ? stateIn : Blocks.f_50016_.m_49966_());
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BaseLockedBlockEntity teStorage;
        BlockEntity tileentity;
        if (player.m_6144_() && this.canAccess((BlockGetter)worldIn, pos, player) && (tileentity = worldIn.m_7702_(pos)) instanceof BaseLockedBlockEntity && (teStorage = (BaseLockedBlockEntity)worldIn.m_7702_(pos)).isLocked() && this.removeLock(worldIn, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        if (this.canAccess((BlockGetter)worldIn, pos, player)) {
            state = (BlockState)state.m_61122_((Property)f_52727_);
            worldIn.m_7731_(pos, state, 10);
            worldIn.m_5898_(player, (Boolean)state.m_61143_((Property)f_52727_) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        BaseLockedBlockEntity tileentity;
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof BaseLockedBlockEntity && (tileentity = (BaseLockedBlockEntity)te).isLocked() && !this.canAccess(worldIn, pos, player)) {
            return -1.0f;
        }
        return super.m_5880_(state, player, worldIn, pos);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BaseLockedBlockEntity teStorage;
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof BaseLockedBlockEntity && (teStorage = (BaseLockedBlockEntity)tileentity).isLocked() && state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER) {
                ItemStack lockStack = new ItemStack((ItemLike)StorageItems.LOCKSMITH_LOCK.get());
                CompoundTag tag = new CompoundTag();
                new StorageLockCode(teStorage.getLockCode()).write(tag);
                lockStack.m_41751_(tag);
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)lockStack);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    private int getCloseSound() {
        return this.f_60442_ == Material.f_76279_ ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.f_60442_ == Material.f_76279_ ? 1005 : 1006;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BaseLockedBlockEntity(pos, state);
    }

    private boolean removeLock(Level worldIn, BlockPos pos, Player entityplayer) {
        BlockState state = worldIn.m_8055_(pos);
        Direction dir = (Direction)state.m_61143_((Property)f_52726_);
        boolean open = (Boolean)state.m_61143_((Property)f_52727_);
        DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)f_52728_);
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52730_);
        BlockState toPlace = (BlockState)((BlockState)((BlockState)this.parent.m_49966_().m_61124_((Property)f_52726_, (Comparable)dir)).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open))).m_61124_((Property)f_52728_, (Comparable)hinge);
        worldIn.m_7731_(pos, (BlockState)toPlace.m_61124_((Property)f_52730_, (Comparable)half), 3);
        worldIn.m_5594_(entityplayer, pos, SoundEvents.f_11748_, SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.nextFloat() * 0.1f + 0.9f);
        if (half == DoubleBlockHalf.UPPER) {
            worldIn.m_7731_(pos.m_7495_(), (BlockState)toPlace.m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER), 3);
        } else {
            worldIn.m_7731_(pos.m_7494_(), (BlockState)toPlace.m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
        return true;
    }

    private boolean canAccess(BlockGetter worldIn, BlockPos pos, Player entityplayer) {
        BaseLockedBlockEntity tileentity = (BaseLockedBlockEntity)worldIn.m_7702_(pos);
        if (tileentity != null && tileentity.isLocked()) {
            for (int slot = 0; slot < entityplayer.m_150109_().m_6643_(); ++slot) {
                String code;
                ItemStack itemstack = entityplayer.m_150109_().m_8020_(slot);
                if (itemstack.m_41619_() || itemstack.m_41720_() != StorageItems.LOCKSMITH_KEY.get() || !itemstack.m_41782_()) continue;
                String string = code = itemstack.m_41783_().m_128425_("Storage_Lock", 8) ? itemstack.m_41783_().m_128461_("Storage_Lock") : "";
                if (code.isEmpty()) continue;
                return tileentity.getLockCode().equals(code);
            }
            return false;
        }
        return true;
    }
}

