/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.blockentity.BaseLockedBlockEntity;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;

public class QuartzDoorBlock
extends DoorBlock
implements EntityBlock {
    public static final BooleanProperty LOCKED = BooleanProperty.m_61465_((String)"locked");

    public QuartzDoorBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52726_, (Comparable)Direction.NORTH)).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52728_, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean isLocked = !this.canBeLocked(worldIn, currentPos);
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_((Property)f_52730_);
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_((Property)f_52730_) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)f_52726_, (Comparable)((Direction)facingState.m_61143_((Property)f_52726_)))).m_61124_((Property)f_52727_, (Comparable)((Boolean)facingState.m_61143_((Property)f_52727_)))).m_61124_((Property)f_52728_, (Comparable)((DoorHingeSide)facingState.m_61143_((Property)f_52728_)))).m_61124_((Property)f_52729_, (Comparable)((Boolean)facingState.m_61143_((Property)f_52729_)))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(isLocked)) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : (BlockState)stateIn.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(isLocked));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52730_, f_52726_, f_52727_, f_52728_, f_52729_, LOCKED});
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        boolean bl = worldIn.m_46753_(pos) || worldIn.m_46753_(pos.m_142300_(state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (blockIn != this && flag != (Boolean)state.m_61143_((Property)f_52729_) && this.canBeLocked((LevelAccessor)worldIn, pos)) {
            if (flag != (Boolean)state.m_61143_((Property)f_52727_)) {
                this.playSound(worldIn, pos, flag);
            }
            worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BaseLockedBlockEntity teStorage;
        BlockEntity tileentity;
        if (this.canBeLocked((LevelAccessor)worldIn, pos) && player.m_21120_(handIn).m_41720_() == StorageItems.LOCKSMITH_LOCK.get() && this.tryPlaceLock(worldIn, pos, player, handIn)) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && this.canAccess((BlockGetter)worldIn, pos, player) && (tileentity = worldIn.m_7702_(pos)) instanceof BaseLockedBlockEntity && (teStorage = (BaseLockedBlockEntity)worldIn.m_7702_(pos)).isLocked()) {
            ItemStack lockStack = new ItemStack((ItemLike)StorageItems.LOCKSMITH_LOCK.get());
            CompoundTag tag = new CompoundTag();
            new StorageLockCode(teStorage.getLockCode()).write(tag);
            lockStack.m_41751_(tag);
            if (this.removeLock(worldIn, pos, player)) {
                ItemEntity blockDropped = new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), lockStack);
                if (!worldIn.f_46443_) {
                    worldIn.m_7967_((Entity)blockDropped);
                    if (!(player instanceof FakePlayer)) {
                        blockDropped.m_6123_(player);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (this.canAccess((BlockGetter)worldIn, pos, player)) {
            state = (BlockState)state.m_61122_((Property)f_52727_);
            worldIn.m_7731_(pos, state, 10);
            worldIn.m_5898_(player, (Boolean)state.m_61143_((Property)f_52727_) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_153165_(Entity entity, Level worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)f_52727_) != open && !((Boolean)state.m_61143_((Property)LOCKED)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(worldIn, pos, open);
            worldIn.m_142346_(entity, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        BaseLockedBlockEntity tileentity;
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof BaseLockedBlockEntity && (tileentity = (BaseLockedBlockEntity)te).isLocked() && !this.canAccess(worldIn, pos, player)) {
            return -1.0f;
        }
        return super.m_5880_(state, player, worldIn, pos);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BaseLockedBlockEntity teStorage;
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof BaseLockedBlockEntity && (teStorage = (BaseLockedBlockEntity)tileentity).isLocked() && state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER) {
                ItemStack lockStack = new ItemStack((ItemLike)StorageItems.LOCKSMITH_LOCK.get());
                CompoundTag tag = new CompoundTag();
                new StorageLockCode(teStorage.getLockCode()).write(tag);
                lockStack.m_41751_(tag);
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)lockStack);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    private void playSound(Level worldIn, BlockPos pos, boolean isOpening) {
        worldIn.m_5898_((Player)null, isOpening ? this.getOpenSound() : this.getCloseSound(), pos, 0);
    }

    private int getCloseSound() {
        return this.f_60442_ == Material.f_76279_ ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.f_60442_ == Material.f_76279_ ? 1005 : 1006;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BaseLockedBlockEntity(pos, state);
    }

    protected boolean canBeLocked(LevelAccessor worldIn, BlockPos pos) {
        return !((BaseLockedBlockEntity)worldIn.m_7702_(pos)).isLocked();
    }

    private boolean removeLock(Level worldIn, BlockPos pos, Player entityplayer) {
        BaseLockedBlockEntity tileentity = (BaseLockedBlockEntity)worldIn.m_7702_(pos);
        tileentity.setLockCode("");
        tileentity.m_58904_().m_5594_(entityplayer, tileentity.m_58899_(), SoundEvents.f_11748_, SoundSource.BLOCKS, 0.5f, tileentity.m_58904_().f_46441_.nextFloat() * 0.1f + 0.9f);
        BlockState state = worldIn.m_8055_(pos);
        BlockState blockstate = Block.m_49931_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos);
        Block.m_49902_((BlockState)state, (BlockState)blockstate, (LevelAccessor)worldIn, (BlockPos)pos, (int)3);
        if (worldIn.m_8055_(pos).m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER) {
            BaseLockedBlockEntity tileentityLower = (BaseLockedBlockEntity)worldIn.m_7702_(pos.m_7495_());
            if (tileentityLower != null) {
                tileentityLower.setLockCode("");
            }
            BlockState stateLower = worldIn.m_8055_(pos.m_7495_());
            BlockState blockstateLower = Block.m_49931_((BlockState)stateLower, (LevelAccessor)worldIn, (BlockPos)pos.m_7495_());
            Block.m_49902_((BlockState)stateLower, (BlockState)blockstateLower, (LevelAccessor)worldIn, (BlockPos)pos.m_7495_(), (int)3);
        } else {
            BaseLockedBlockEntity tileentityUpper = (BaseLockedBlockEntity)worldIn.m_7702_(pos.m_7494_());
            if (tileentityUpper != null) {
                tileentityUpper.setLockCode("");
            }
            BlockState stateUpper = worldIn.m_8055_(pos.m_7494_());
            BlockState blockstateUpper = Block.m_49931_((BlockState)stateUpper, (LevelAccessor)worldIn, (BlockPos)pos.m_7494_());
            Block.m_49902_((BlockState)stateUpper, (BlockState)blockstateUpper, (LevelAccessor)worldIn, (BlockPos)pos.m_7494_(), (int)3);
        }
        return true;
    }

    private boolean tryPlaceLock(Level worldIn, BlockPos pos, Player entityplayer, InteractionHand hand) {
        ItemStack itemstack = entityplayer.m_21120_(hand);
        if (itemstack.m_41782_()) {
            String code;
            String string = code = itemstack.m_41783_().m_128425_("Storage_Lock", 8) ? itemstack.m_41783_().m_128461_("Storage_Lock") : "";
            if (!code.isEmpty()) {
                BaseLockedBlockEntity tileentity = (BaseLockedBlockEntity)worldIn.m_7702_(pos);
                if (!entityplayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                tileentity.setLockCode(code);
                tileentity.m_58904_().m_5594_(entityplayer, tileentity.m_58899_(), SoundEvents.f_11748_, SoundSource.BLOCKS, 0.5f, tileentity.m_58904_().f_46441_.nextFloat() * 0.1f + 0.9f);
                BlockState state = worldIn.m_8055_(pos);
                BlockState blockstate = Block.m_49931_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos);
                Block.m_49902_((BlockState)state, (BlockState)blockstate, (LevelAccessor)worldIn, (BlockPos)pos, (int)3);
                if (state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER) {
                    BaseLockedBlockEntity tileentityLower = (BaseLockedBlockEntity)worldIn.m_7702_(pos.m_7495_());
                    if (tileentityLower != null) {
                        tileentityLower.setLockCode(code);
                    }
                    BlockState stateLower = worldIn.m_8055_(pos.m_7495_());
                    BlockState blockstateLower = Block.m_49931_((BlockState)stateLower, (LevelAccessor)worldIn, (BlockPos)pos.m_7495_());
                    Block.m_49902_((BlockState)stateLower, (BlockState)blockstateLower, (LevelAccessor)worldIn, (BlockPos)pos.m_7495_(), (int)3);
                } else {
                    BaseLockedBlockEntity tileentityUpper = (BaseLockedBlockEntity)worldIn.m_7702_(pos.m_7494_());
                    if (tileentityUpper != null) {
                        tileentityUpper.setLockCode(code);
                    }
                    BlockState stateUpper = worldIn.m_8055_(pos.m_7494_());
                    BlockState blockstateUpper = Block.m_49931_((BlockState)stateUpper, (LevelAccessor)worldIn, (BlockPos)pos.m_7494_());
                    Block.m_49902_((BlockState)stateUpper, (BlockState)blockstateUpper, (LevelAccessor)worldIn, (BlockPos)pos.m_7494_(), (int)3);
                }
                return true;
            }
        }
        return false;
    }

    private boolean canAccess(BlockGetter worldIn, BlockPos pos, Player entityplayer) {
        BaseLockedBlockEntity tileentity = (BaseLockedBlockEntity)worldIn.m_7702_(pos);
        if (tileentity.isLocked()) {
            for (int slot = 0; slot < entityplayer.m_150109_().m_6643_(); ++slot) {
                String code;
                ItemStack itemstack = entityplayer.m_150109_().m_8020_(slot);
                if (itemstack.m_41619_() || itemstack.m_41720_() != StorageItems.LOCKSMITH_KEY.get() || !itemstack.m_41782_()) continue;
                String string = code = itemstack.m_41783_().m_128425_("Storage_Lock", 8) ? itemstack.m_41783_().m_128461_("Storage_Lock") : "";
                if (code.isEmpty()) continue;
                return tileentity.getLockCode().equals(code);
            }
            return false;
        }
        return true;
    }
}

