/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.google.common.collect.Sets;
import com.grim3212.assorted.storage.AssortedStorage;
import com.grim3212.assorted.storage.common.block.GlassCabinetBlock;
import com.grim3212.assorted.storage.common.block.GoldSafeBlock;
import com.grim3212.assorted.storage.common.block.ItemTowerBlock;
import com.grim3212.assorted.storage.common.block.LockedDoorBlock;
import com.grim3212.assorted.storage.common.block.LockerBlock;
import com.grim3212.assorted.storage.common.block.LocksmithWorkbenchBlock;
import com.grim3212.assorted.storage.common.block.ObsidianSafeBlock;
import com.grim3212.assorted.storage.common.block.WarehouseCrateBlock;
import com.grim3212.assorted.storage.common.block.WoodCabinetBlock;
import com.grim3212.assorted.storage.common.item.LockerItem;
import com.grim3212.assorted.storage.common.item.StorageBlockItem;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.item.WarehouseCrateBlockItem;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StorageBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"assortedstorage");
    public static final DeferredRegister<Item> ITEMS = StorageItems.ITEMS;
    public static final RegistryObject<LocksmithWorkbenchBlock> LOCKSMITH_WORKBENCH = StorageBlocks.register("locksmith_workbench", () -> new LocksmithWorkbenchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(3.0f, 5.0f)));
    public static final RegistryObject<WoodCabinetBlock> WOOD_CABINET = StorageBlocks.registerStorageItem("wood_cabinet", () -> new WoodCabinetBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<GlassCabinetBlock> GLASS_CABINET = StorageBlocks.registerStorageItem("glass_cabinet", () -> new GlassCabinetBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<GoldSafeBlock> GOLD_SAFE = StorageBlocks.registerStorageItem("gold_safe", () -> new GoldSafeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<ObsidianSafeBlock> OBSIDIAN_SAFE = StorageBlocks.registerStorageItem("obsidian_safe", () -> new ObsidianSafeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<LockerBlock> LOCKER = StorageBlocks.registerWithItem("locker", () -> new LockerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_)), StorageBlocks.lockerItem());
    public static final RegistryObject<ItemTowerBlock> ITEM_TOWER = StorageBlocks.registerStorageItem("item_tower", () -> new ItemTowerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<WarehouseCrateBlock> OAK_WAREHOUSE_CRATE = StorageBlocks.registerCrate("oak_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.f_61830_));
    public static final RegistryObject<WarehouseCrateBlock> BIRCH_WAREHOUSE_CRATE = StorageBlocks.registerCrate("birch_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.f_61832_));
    public static final RegistryObject<WarehouseCrateBlock> SPRUCE_WAREHOUSE_CRATE = StorageBlocks.registerCrate("spruce_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.f_61831_));
    public static final RegistryObject<WarehouseCrateBlock> ACACIA_WAREHOUSE_CRATE = StorageBlocks.registerCrate("acacia_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.f_61833_));
    public static final RegistryObject<WarehouseCrateBlock> DARK_OAK_WAREHOUSE_CRATE = StorageBlocks.registerCrate("dark_oak_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.f_61835_));
    public static final RegistryObject<WarehouseCrateBlock> JUNGLE_WAREHOUSE_CRATE = StorageBlocks.registerCrate("jungle_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.f_61834_));
    public static final RegistryObject<WarehouseCrateBlock> WARPED_WAREHOUSE_CRATE = StorageBlocks.registerCrate("warped_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.f_61837_));
    public static final RegistryObject<WarehouseCrateBlock> CRIMSON_WAREHOUSE_CRATE = StorageBlocks.registerCrate("crimson_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.f_61836_));
    public static final RegistryObject<LockedDoorBlock> LOCKED_OAK_DOOR = StorageBlocks.registerNoItem("locked_oak_door", () -> new LockedDoorBlock(Blocks.f_50154_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_SPRUCE_DOOR = StorageBlocks.registerNoItem("locked_spruce_door", () -> new LockedDoorBlock(Blocks.f_50484_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76370_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_BIRCH_DOOR = StorageBlocks.registerNoItem("locked_birch_door", () -> new LockedDoorBlock(Blocks.f_50485_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76400_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_JUNGLE_DOOR = StorageBlocks.registerNoItem("locked_jungle_door", () -> new LockedDoorBlock(Blocks.f_50486_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76408_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_ACACIA_DOOR = StorageBlocks.registerNoItem("locked_acacia_door", () -> new LockedDoorBlock(Blocks.f_50487_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76413_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_DARK_OAK_DOOR = StorageBlocks.registerNoItem("locked_dark_oak_door", () -> new LockedDoorBlock(Blocks.f_50488_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76362_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_CRIMSON_DOOR = StorageBlocks.registerNoItem("locked_crimson_door", () -> new LockedDoorBlock(Blocks.f_50671_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76321_, (MaterialColor)MaterialColor.f_76390_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_WARPED_DOOR = StorageBlocks.registerNoItem("locked_warped_door", () -> new LockedDoorBlock(Blocks.f_50672_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76321_, (MaterialColor)MaterialColor.f_76393_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_IRON_DOOR = StorageBlocks.registerNoItem("locked_iron_door", () -> new LockedDoorBlock(Blocks.f_50166_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60999_().m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_QUARTZ_DOOR = StorageBlocks.registerNoItem("locked_quartz_door", () -> new LockedDoorBlock(new ResourceLocation("assorteddecor:quartz_door"), BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76412_).m_60999_().m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_()));

    public static Set<Block> lockedDoors() {
        return Sets.newHashSet((Object[])new Block[]{(Block)LOCKED_OAK_DOOR.get(), (Block)LOCKED_SPRUCE_DOOR.get(), (Block)LOCKED_BIRCH_DOOR.get(), (Block)LOCKED_JUNGLE_DOOR.get(), (Block)LOCKED_ACACIA_DOOR.get(), (Block)LOCKED_DARK_OAK_DOOR.get(), (Block)LOCKED_CRIMSON_DOOR.get(), (Block)LOCKED_WARPED_DOOR.get(), (Block)LOCKED_IRON_DOOR.get(), (Block)LOCKED_QUARTZ_DOOR.get()});
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        return StorageBlocks.register(name, sup, block -> StorageBlocks.item((RegistryObject<? extends Block>)block));
    }

    private static <T extends Block> RegistryObject<T> registerCrate(String name, Supplier<? extends T> sup) {
        return StorageBlocks.register(name, sup, block -> StorageBlocks.crateItem((RegistryObject<? extends Block>)block));
    }

    private static <T extends Block> RegistryObject<T> registerStorageItem(String name, Supplier<? extends T> sup) {
        return StorageBlocks.register(name, sup, block -> StorageBlocks.storageItem((RegistryObject<? extends Block>)block));
    }

    private static <T extends Block> RegistryObject<T> registerWithItem(String name, Supplier<? extends T> sup, Supplier<BlockItem> blockItem) {
        return StorageBlocks.register(name, sup, block -> blockItem);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = StorageBlocks.registerNoItem(name, sup);
        ITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(AssortedStorage.ASSORTED_STORAGE_ITEM_GROUP));
    }

    private static Supplier<StorageBlockItem> storageItem(RegistryObject<? extends Block> block) {
        return () -> new StorageBlockItem((Block)block.get(), new Item.Properties().m_41491_(AssortedStorage.ASSORTED_STORAGE_ITEM_GROUP));
    }

    private static Supplier<WarehouseCrateBlockItem> crateItem(RegistryObject<? extends Block> block) {
        return () -> new WarehouseCrateBlockItem((Block)block.get(), new Item.Properties().m_41491_(AssortedStorage.ASSORTED_STORAGE_ITEM_GROUP));
    }

    private static Supplier<BlockItem> lockerItem() {
        return () -> new LockerItem(new Item.Properties().m_41491_(AssortedStorage.ASSORTED_STORAGE_ITEM_GROUP));
    }
}

