/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block.blockentity;

import com.grim3212.assorted.storage.common.block.blockentity.StorageBlockEntityTypes;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BaseLockedBlockEntity
extends BlockEntity {
    private StorageLockCode lockCode = StorageLockCode.EMPTY_CODE;

    public BaseLockedBlockEntity(BlockEntityType<BaseLockedBlockEntity> tileEntityType, BlockPos pos, BlockState state) {
        super((BlockEntityType)StorageBlockEntityTypes.BASE_LOCKED.get(), pos, state);
    }

    public BaseLockedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StorageBlockEntityTypes.BASE_LOCKED.get(), pos, state);
    }

    public boolean isLocked() {
        return this.lockCode != null && this.lockCode != StorageLockCode.EMPTY_CODE;
    }

    public String getLockCode() {
        return this.lockCode.getLockCode();
    }

    public void setLockCode(String s) {
        this.lockCode = s == null || s.isEmpty() ? StorageLockCode.EMPTY_CODE : new StorageLockCode(s);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            if (!this.f_58857_.f_46443_) {
                this.f_58857_.m_6289_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readPacketNBT(nbt);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        this.writePacketNBT(compound);
        return compound;
    }

    public void writePacketNBT(CompoundTag cmp) {
        this.lockCode.write(cmp);
    }

    public void readPacketNBT(CompoundTag cmp) {
        this.lockCode = StorageLockCode.read(cmp);
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.writePacketNBT(nbtTagCompound);
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, nbtTagCompound);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readPacketNBT(pkt.m_131708_());
        this.requestModelDataUpdate();
        if (this.f_58857_ instanceof ClientLevel) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }
}

