/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block.blockentity;

import com.grim3212.assorted.storage.common.block.BaseStorageBlock;
import com.grim3212.assorted.storage.common.block.blockentity.IStorage;
import com.grim3212.assorted.storage.common.inventory.StorageContainer;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@OnlyIn(value=Dist.CLIENT, _interface=IStorage.class)
public abstract class BaseStorageBlockEntity
extends BlockEntity
implements WorldlyContainer,
MenuProvider,
Nameable,
IStorage {
    private NonNullList<ItemStack> chestContents;
    protected int numPlayersUsing;
    private int ticksSinceSync;
    protected float rotation;
    protected float prevRotation;
    private StorageLockCode lockCode = StorageLockCode.EMPTY_CODE;
    private Component customName;
    private LazyOptional<?> storageItemHandler = LazyOptional.of(() -> this.createSidedHandler());
    protected static final int[] DEFAULT_SLOTS = IntStream.range(0, 27).toArray();

    protected BaseStorageBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        this(typeIn, pos, state, 27);
    }

    protected BaseStorageBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state, int inventorySize) {
        super(typeIn, pos, state);
        this.chestContents = NonNullList.m_122780_((int)inventorySize, (Object)ItemStack.f_41583_);
    }

    public boolean isLocked() {
        return this.lockCode != null && this.lockCode != StorageLockCode.EMPTY_CODE;
    }

    public String getLockCode() {
        return this.lockCode.getLockCode();
    }

    public void setLockCode(String s) {
        this.lockCode = s == null || s.isEmpty() ? StorageLockCode.EMPTY_CODE : new StorageLockCode(s);
    }

    public int m_6643_() {
        return this.getItems().size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.chestContents) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected abstract Component getDefaultName();

    public void tick() {
        int i = this.f_58858_.m_123341_();
        int j = this.f_58858_.m_123342_();
        int k = this.f_58858_.m_123343_();
        ++this.ticksSinceSync;
        this.numPlayersUsing = BaseStorageBlockEntity.getNumberOfPlayersUsing(this.f_58857_, this, this.ticksSinceSync, i, j, k, this.numPlayersUsing);
        this.prevRotation = this.rotation;
        if (this.numPlayersUsing > 0 && this.rotation == 0.0f) {
            this.playSound(SoundEvents.f_11749_);
        }
        if (this.numPlayersUsing == 0 && this.rotation > 0.0f || this.numPlayersUsing > 0 && this.rotation < 1.0f) {
            float f1 = this.rotation;
            this.rotation = this.numPlayersUsing > 0 ? (this.rotation += 0.1f) : (this.rotation -= 0.1f);
            if (this.rotation > 1.0f) {
                this.rotation = 1.0f;
            }
            if (this.rotation < 0.5f && f1 >= 0.5f) {
                this.playSound(SoundEvents.f_11747_);
            }
            if (this.rotation < 0.0f) {
                this.rotation = 0.0f;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getRotation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevRotation, (float)this.rotation);
    }

    public static int getNumberOfPlayersUsing(Level worldIn, BaseStorageBlockEntity lockableTileEntity, int ticksSinceSync, int x, int y, int z, int numPlayersUsing) {
        if (!worldIn.f_46443_ && numPlayersUsing != 0 && (ticksSinceSync + x + y + z) % 200 == 0) {
            numPlayersUsing = BaseStorageBlockEntity.getNumberOfPlayersUsing(worldIn, lockableTileEntity, x, y, z);
        }
        return numPlayersUsing;
    }

    public static int getNumberOfPlayersUsing(Level world, BaseStorageBlockEntity lockableTileEntity, int x, int y, int z) {
        int i = 0;
        for (Player playerentity : world.m_45976_(Player.class, new AABB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            if (!(playerentity.f_36096_ instanceof StorageContainer)) continue;
            ++i;
        }
        return i;
    }

    private void playSound(SoundEvent soundIn) {
        double d0 = (double)this.f_58858_.m_123341_() + 0.5;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_6263_((Player)null, d0, d1, d2, soundIn, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof BaseStorageBlock) {
            this.f_58857_.m_7696_(this.f_58858_, block, 1, this.numPlayersUsing);
            this.f_58857_.m_46672_(this.f_58858_, block);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.chestContents;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.chestContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.chestContents);
        if (nbt.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)nbt.m_128461_("CustomName"));
        }
        this.readPacketNBT(nbt);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.chestContents);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        this.writePacketNBT(compound);
        return compound;
    }

    public CompoundTag saveToNbt(CompoundTag compound) {
        ContainerHelper.m_18976_((CompoundTag)compound, this.chestContents, (boolean)false);
        return compound;
    }

    public void writePacketNBT(CompoundTag cmp) {
        this.lockCode.write(cmp);
    }

    public void readPacketNBT(CompoundTag cmp) {
        this.lockCode = StorageLockCode.read(cmp);
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.writePacketNBT(nbtTagCompound);
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, nbtTagCompound);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readPacketNBT(pkt.m_131708_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.storageItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected IItemHandler createSidedHandler() {
        return new SidedInvWrapper((WorldlyContainer)this, null);
    }

    public void m_7651_() {
        super.m_7651_();
        this.storageItemHandler.invalidate();
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.getItems(), (int)index, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.getItems(), (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.getItems().set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public int[] m_7071_(Direction side) {
        return DEFAULT_SLOTS;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return !this.isLocked();
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.isLocked();
    }
}

