/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block.blockentity;

import com.grim3212.assorted.storage.client.model.ItemTowerModel;
import com.grim3212.assorted.storage.client.model.StorageModelLayers;
import com.grim3212.assorted.storage.common.block.blockentity.BaseStorageBlockEntity;
import com.grim3212.assorted.storage.common.block.blockentity.StorageBlockEntityTypes;
import com.grim3212.assorted.storage.common.inventory.ItemTowerContainer;
import com.grim3212.assorted.storage.common.inventory.ItemTowerInventory;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ItemTowerBlockEntity
extends BaseStorageBlockEntity {
    @OnlyIn(value=Dist.CLIENT)
    public ItemTowerModel model;
    protected static final int[] ITEM_TOWER_SLOTS = IntStream.range(0, 18).toArray();
    private LazyOptional<?> itemTowerItemHandler = LazyOptional.of(() -> this.createSidedHandler());

    public ItemTowerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StorageBlockEntityTypes.ITEM_TOWER.get(), pos, state, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animate(int animId) {
        if (this.model == null) {
            this.model = new ItemTowerModel(Minecraft.m_91087_().m_167973_().m_171103_(StorageModelLayers.ITEM_TOWER));
        }
        this.model.setAnimation(animId);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory player, Player playerEntity) {
        return ItemTowerContainer.createItemTowerContainer(windowId, player, (Container)new ItemTowerInventory(this.getItemTowers(), this.f_58858_));
    }

    @Override
    protected Component getDefaultName() {
        return new TranslatableComponent("assortedstorage.container.item_tower");
    }

    @Override
    public int[] m_7071_(Direction side) {
        return ITEM_TOWER_SLOTS;
    }

    public NonNullList<ItemTowerBlockEntity> getItemTowers() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        NonNullList itemTowers = NonNullList.m_122779_();
        int downBlocks = 1;
        while (this.f_58857_.m_8055_(this.f_58858_.m_6625_(downBlocks)) == state) {
            ++downBlocks;
        }
        int upBlocks = 1;
        BlockPos bottomPos = this.f_58858_.m_6625_(downBlocks);
        while (this.f_58857_.m_8055_(bottomPos.m_6630_(upBlocks)) == state) {
            itemTowers.add((Object)((ItemTowerBlockEntity)this.f_58857_.m_7702_(bottomPos.m_6630_(upBlocks))));
            ++upBlocks;
        }
        return itemTowers;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemTowerItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected IItemHandler createSidedHandler() {
        return new SidedInvWrapper((WorldlyContainer)new ItemTowerInventory(this.getItemTowers(), this.f_58858_), null);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.itemTowerItemHandler.invalidate();
    }
}

