/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block.blockentity;

import com.grim3212.assorted.storage.common.block.blockentity.BaseStorageBlockEntity;
import com.grim3212.assorted.storage.common.block.blockentity.StorageBlockEntityTypes;
import com.grim3212.assorted.storage.common.inventory.DualLockerInventory;
import com.grim3212.assorted.storage.common.inventory.LockerContainer;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class LockerBlockEntity
extends BaseStorageBlockEntity {
    private LazyOptional<?> lockerItemHandler = LazyOptional.of(() -> this.createSidedHandler());
    protected static final int[] LOCKER_SLOTS = IntStream.range(0, 45).toArray();

    public LockerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StorageBlockEntityTypes.LOCKER.get(), pos, state, 45);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory player, Player playerEntity) {
        BlockEntity lockerUp = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (lockerUp != null && lockerUp instanceof LockerBlockEntity) {
            return LockerContainer.createDualLockerContainer(windowId, player, (Container)new DualLockerInventory(this, (LockerBlockEntity)lockerUp));
        }
        return LockerContainer.createLockerContainer(windowId, player, (Container)this);
    }

    @Override
    protected Component getDefaultName() {
        return new TranslatableComponent("assortedstorage.container.locker");
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lockerItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected IItemHandler createSidedHandler() {
        BlockEntity lockerUp = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (lockerUp != null && lockerUp instanceof LockerBlockEntity) {
            return new SidedInvWrapper((WorldlyContainer)new DualLockerInventory(this, (LockerBlockEntity)lockerUp), null);
        }
        BlockEntity lockerDown = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (lockerDown != null && lockerDown instanceof LockerBlockEntity) {
            return new SidedInvWrapper((WorldlyContainer)new DualLockerInventory((LockerBlockEntity)lockerDown, this), null);
        }
        return super.createSidedHandler();
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.lockerItemHandler.invalidate();
    }

    @Override
    public int[] m_7071_(Direction side) {
        return LOCKER_SLOTS;
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        BlockEntity lockerDown = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (lockerDown != null && lockerDown instanceof LockerBlockEntity) {
            return ((LockerBlockEntity)lockerDown).m_7155_(index, itemStackIn, direction);
        }
        return super.m_7155_(index, itemStackIn, direction);
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        BlockEntity lockerDown = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (lockerDown != null && lockerDown instanceof LockerBlockEntity) {
            return ((LockerBlockEntity)lockerDown).m_7157_(index, stack, direction);
        }
        return super.m_7157_(index, stack, direction);
    }

    public AABB getRenderBoundingBox() {
        return this.hasUpperLocker() ? super.getRenderBoundingBox().m_82363_(0.0, 1.0, 0.0) : super.getRenderBoundingBox();
    }

    public boolean isUpperLocker() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_8055_(this.f_58858_.m_7495_()) == this.f_58857_.m_8055_(this.f_58858_);
    }

    public boolean hasUpperLocker() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_8055_(this.f_58858_.m_7494_()) == this.f_58857_.m_8055_(this.f_58858_);
    }

    public LockerBlockEntity getUpperLocker() {
        if (this.f_58857_ == null || !this.hasUpperLocker()) {
            return null;
        }
        return (LockerBlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_7494_());
    }

    public boolean isBottomLocker() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_8055_(this.f_58858_.m_7494_()) == this.f_58857_.m_8055_(this.f_58858_);
    }

    public boolean hasBottomLocker() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_8055_(this.f_58858_.m_7495_()) == this.f_58857_.m_8055_(this.f_58858_);
    }

    public LockerBlockEntity getBottomLocker() {
        if (this.f_58857_ == null || !this.hasUpperLocker()) {
            return null;
        }
        return (LockerBlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_7495_());
    }
}

