/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.grim3212.assorted.storage.common.block.GoldSafeBlock;
import com.grim3212.assorted.storage.common.block.StorageBlocks;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class StorageLootProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final List<Block> blocks = new ArrayList<Block>();

    public StorageLootProvider(DataGenerator generator) {
        this.generator = generator;
        this.blocks.add((Block)StorageBlocks.WOOD_CABINET.get());
        this.blocks.add((Block)StorageBlocks.GLASS_CABINET.get());
        this.blocks.add((Block)StorageBlocks.OBSIDIAN_SAFE.get());
        this.blocks.add((Block)StorageBlocks.LOCKER.get());
        this.blocks.add((Block)StorageBlocks.ITEM_TOWER.get());
        this.blocks.add((Block)StorageBlocks.LOCKSMITH_WORKBENCH.get());
        this.blocks.add((Block)StorageBlocks.OAK_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.BIRCH_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.SPRUCE_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.ACACIA_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.DARK_OAK_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.JUNGLE_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.WARPED_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.CRIMSON_WAREHOUSE_CRATE.get());
    }

    public void m_6865_(HashCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block block : this.blocks) {
            tables.put(block.getRegistryName(), StorageLootProvider.genRegular(block));
        }
        tables.put(StorageBlocks.GOLD_SAFE.getId(), StorageLootProvider.genInventoryStorage((Block)StorageBlocks.GOLD_SAFE.get()));
        for (Map.Entry entry : tables.entrySet()) {
            Path path = StorageLootProvider.getPath(this.generator.m_123916_(), (ResourceLocation)entry.getKey());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)((LootTable.Builder)entry.getValue()).m_79165_(LootContextParamSets.f_81421_).m_79167_()), (Path)path);
        }
        this.door((Block)StorageBlocks.LOCKED_IRON_DOOR.get(), Blocks.f_50166_, cache);
        this.door((Block)StorageBlocks.LOCKED_OAK_DOOR.get(), Blocks.f_50154_, cache);
        this.door((Block)StorageBlocks.LOCKED_SPRUCE_DOOR.get(), Blocks.f_50484_, cache);
        this.door((Block)StorageBlocks.LOCKED_BIRCH_DOOR.get(), Blocks.f_50485_, cache);
        this.door((Block)StorageBlocks.LOCKED_ACACIA_DOOR.get(), Blocks.f_50487_, cache);
        this.door((Block)StorageBlocks.LOCKED_JUNGLE_DOOR.get(), Blocks.f_50486_, cache);
        this.door((Block)StorageBlocks.LOCKED_DARK_OAK_DOOR.get(), Blocks.f_50488_, cache);
        this.door((Block)StorageBlocks.LOCKED_CRIMSON_DOOR.get(), Blocks.f_50671_, cache);
        this.door((Block)StorageBlocks.LOCKED_WARPED_DOOR.get(), Blocks.f_50672_, cache);
    }

    private void door(Block b, Block out, HashCache cache) throws IOException {
        Path doorPath = StorageLootProvider.getPath(this.generator.m_123916_(), b.getRegistryName());
        DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)StorageLootProvider.genDoor(b, out).m_79165_(LootContextParamSets.f_81421_).m_79167_()), (Path)doorPath);
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/blocks/" + id.m_135815_() + ".json");
    }

    private static LootTable.Builder genDoor(Block b, Block out) {
        LootItemBlockStatePropertyCondition.Builder halfCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
        LootPoolEntryContainer.Builder entry = LootItem.m_79579_((ItemLike)out).m_6509_((LootItemCondition.Builder)halfCondition);
        LootPool.Builder pool = LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(entry).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    private static LootTable.Builder genRegular(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b);
        LootPool.Builder pool = LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    private static LootTable.Builder genInventoryStorage(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)SetContainerContents.m_80926_().m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)GoldSafeBlock.CONTENTS)));
        LootPool.Builder pool = LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    public String m_6055_() {
        return "Assorted Storage loot tables";
    }
}

