/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.inventory;

import com.grim3212.assorted.storage.common.block.blockentity.ItemTowerBlockEntity;
import com.grim3212.assorted.storage.common.inventory.ItemTowerInventory;
import com.grim3212.assorted.storage.common.inventory.MoveableSlot;
import com.grim3212.assorted.storage.common.inventory.StorageContainerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.IContainerFactory;

public class ItemTowerContainer
extends AbstractContainerMenu {
    private final Container inventory;

    public static ItemTowerContainer createItemTowerContainer(int windowId, Inventory playerInventory, Container inventory) {
        return new ItemTowerContainer((MenuType)StorageContainerTypes.ITEM_TOWER.get(), windowId, playerInventory, inventory);
    }

    public ItemTowerContainer(MenuType<?> containerType, int windowId, Inventory playerInventory, Container inventory) {
        super(containerType, windowId);
        this.inventory = inventory;
        inventory.m_5856_(playerInventory.f_35978_);
        int numRows = this.inventory.m_6643_() / 9;
        for (int chestRow = 0; chestRow < numRows; ++chestRow) {
            for (int chestCol = 0; chestCol < 9; ++chestCol) {
                this.m_38897_(new MoveableSlot(inventory, chestCol + chestRow * 9, 8 + chestCol * 18, 18 + chestRow * 18));
            }
        }
        int leftCol = 8;
        int heighOffset = 150;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.m_38897_(new Slot((Container)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, heighOffset - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, heighOffset - 24));
        }
        if (playerInventory.f_35978_.f_19853_.f_46443_) {
            this.setDisplayRow(0);
        }
    }

    public Container getItemTowerInventory() {
        return this.inventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDisplayRow(int row) {
        int minSlot = row * 9;
        int maxSlot = (row + 2) * 9;
        int numRows = this.inventory.m_6643_() / 9;
        for (int slotIndex = 0; slotIndex < numRows * 9; ++slotIndex) {
            int modColumn;
            int modRow;
            if (row == numRows - 1) {
                if (slotIndex >= minSlot && slotIndex < maxSlot) {
                    modRow = (int)Math.floor((double)(slotIndex - minSlot) / 9.0);
                    modColumn = slotIndex % 9;
                    ((MoveableSlot)((Object)this.f_38839_.get(slotIndex))).setSlotPosition(8 + modColumn * 18, 18 + modRow * 18);
                    continue;
                }
                if (slotIndex >= 0 && slotIndex < 9) {
                    modRow = (int)Math.floor((double)(slotIndex + maxSlot - minSlot - 9) / 9.0);
                    modColumn = slotIndex % 9;
                    ((MoveableSlot)((Object)this.f_38839_.get(slotIndex))).setSlotPosition(8 + modColumn * 18, 18 + modRow * 18);
                    continue;
                }
                ((MoveableSlot)((Object)this.f_38839_.get(slotIndex))).setSlotDisabled();
                continue;
            }
            if (slotIndex >= minSlot && slotIndex < maxSlot) {
                modRow = (int)Math.floor((double)(slotIndex - minSlot) / 9.0);
                modColumn = slotIndex % 9;
                ((MoveableSlot)((Object)this.f_38839_.get(slotIndex))).setSlotPosition(8 + modColumn * 18, 18 + modRow * 18);
                continue;
            }
            ((MoveableSlot)((Object)this.f_38839_.get(slotIndex))).setSlotDisabled();
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.inventory.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int maxSlot = this.inventory.m_6643_();
            if (index < maxSlot ? !this.m_38903_(itemstack1, maxSlot, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, maxSlot, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_5785_(playerIn);
    }

    public static class ItemTowerContainerFactory<T extends AbstractContainerMenu>
    implements IContainerFactory<ItemTowerContainer> {
        public ItemTowerContainer create(int windowId, Inventory inv, FriendlyByteBuf data) {
            Level world = inv.f_35978_.f_19853_;
            BlockPos pos = data.m_130135_();
            BlockEntity te = world.m_7702_(pos);
            if (te != null && te instanceof ItemTowerBlockEntity) {
                ItemTowerBlockEntity towerTileEntity = (ItemTowerBlockEntity)te;
                return new ItemTowerContainer((MenuType)StorageContainerTypes.ITEM_TOWER.get(), windowId, inv, (Container)new ItemTowerInventory(towerTileEntity.getItemTowers(), pos));
            }
            return new ItemTowerContainer((MenuType)StorageContainerTypes.ITEM_TOWER.get(), windowId, inv, (Container)new SimpleContainer(18));
        }
    }
}

