/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.inventory;

import com.grim3212.assorted.storage.common.inventory.MoveableSlot;
import com.grim3212.assorted.storage.common.inventory.StorageContainerTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LockerContainer
extends AbstractContainerMenu {
    private final Container inventory;
    private final int numRows;

    public static LockerContainer createLockerContainer(int windowId, Inventory playerInventory) {
        return new LockerContainer((MenuType)StorageContainerTypes.LOCKER.get(), windowId, playerInventory, (Container)new SimpleContainer(45), 5);
    }

    public static LockerContainer createLockerContainer(int windowId, Inventory playerInventory, Container inventory) {
        return new LockerContainer((MenuType)StorageContainerTypes.LOCKER.get(), windowId, playerInventory, inventory, 5);
    }

    public static LockerContainer createDualLockerContainer(int windowId, Inventory playerInventory) {
        return new LockerContainer((MenuType)StorageContainerTypes.DUAL_LOCKER.get(), windowId, playerInventory, (Container)new SimpleContainer(90), 10);
    }

    public static LockerContainer createDualLockerContainer(int windowId, Inventory playerInventory, Container inventory) {
        return new LockerContainer((MenuType)StorageContainerTypes.DUAL_LOCKER.get(), windowId, playerInventory, inventory, 10);
    }

    public LockerContainer(MenuType<?> containerType, int windowId, Inventory playerInventory, Container inventory, int numRows) {
        super(containerType, windowId);
        this.inventory = inventory;
        this.numRows = numRows;
        inventory.m_5856_(playerInventory.f_35978_);
        for (int chestRow = 0; chestRow < numRows; ++chestRow) {
            for (int chestCol = 0; chestCol < 9; ++chestCol) {
                this.m_38897_(new MoveableSlot(inventory, chestCol + chestRow * 9, 8 + chestCol * 18, 18 + chestRow * 18));
            }
        }
        int leftCol = 8;
        int heighOffset = 203;
        if (this.numRows > 5) {
            ++heighOffset;
        }
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.m_38897_(new Slot((Container)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, heighOffset - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, heighOffset - 24));
        }
        if (playerInventory.f_35978_.f_19853_.f_46443_) {
            this.setDisplayRow(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDisplayRow(int row) {
        int minSlot = row * 9;
        int maxSlot = (row + 5) * 9;
        for (int slotIndex = 0; slotIndex < this.numRows * 9; ++slotIndex) {
            if (slotIndex >= minSlot && slotIndex < maxSlot) {
                int modRow = (int)Math.floor((double)(slotIndex - minSlot) / 9.0);
                int modColumn = slotIndex % 9;
                ((MoveableSlot)((Object)this.f_38839_.get(slotIndex))).setSlotPosition(8 + modColumn * 18, 18 + modRow * 18);
                continue;
            }
            ((MoveableSlot)((Object)this.f_38839_.get(slotIndex))).setSlotDisabled();
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.inventory.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int maxSlot = this.inventory.m_6643_();
            if (index < maxSlot ? !this.m_38903_(itemstack1, maxSlot, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, maxSlot, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_5785_(playerIn);
    }
}

