/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.item;

import com.google.common.collect.Maps;
import com.grim3212.assorted.storage.common.block.StorageBlocks;
import com.grim3212.assorted.storage.common.block.blockentity.BaseLockedBlockEntity;
import com.grim3212.assorted.storage.common.item.CombinationItem;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class PadlockItem
extends CombinationItem {
    private final Map<Block, Block> doorMapping = Maps.newHashMap();

    public PadlockItem(Item.Properties properties) {
        super(properties);
        this.doorMapping.put(Blocks.f_50154_, (Block)StorageBlocks.LOCKED_OAK_DOOR.get());
        this.doorMapping.put(Blocks.f_50484_, (Block)StorageBlocks.LOCKED_SPRUCE_DOOR.get());
        this.doorMapping.put(Blocks.f_50485_, (Block)StorageBlocks.LOCKED_BIRCH_DOOR.get());
        this.doorMapping.put(Blocks.f_50487_, (Block)StorageBlocks.LOCKED_ACACIA_DOOR.get());
        this.doorMapping.put(Blocks.f_50486_, (Block)StorageBlocks.LOCKED_JUNGLE_DOOR.get());
        this.doorMapping.put(Blocks.f_50488_, (Block)StorageBlocks.LOCKED_DARK_OAK_DOOR.get());
        this.doorMapping.put(Blocks.f_50671_, (Block)StorageBlocks.LOCKED_CRIMSON_DOOR.get());
        this.doorMapping.put(Blocks.f_50672_, (Block)StorageBlocks.LOCKED_WARPED_DOOR.get());
        this.doorMapping.put(Blocks.f_50166_, (Block)StorageBlocks.LOCKED_IRON_DOOR.get());
        Block quartzDoor = (Block)Registry.f_122824_.m_7745_(new ResourceLocation("assorteddecor:quartz_door"));
        if (quartzDoor != Blocks.f_50016_) {
            this.doorMapping.put(quartzDoor, (Block)StorageBlocks.LOCKED_QUARTZ_DOOR.get());
        }
    }

    private Block getMatchingDoor(Block doorIn) {
        if (this.doorMapping.containsKey(doorIn)) {
            return this.doorMapping.get(doorIn);
        }
        return Blocks.f_50016_;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        if (world.m_8055_(pos).m_60734_() instanceof DoorBlock && this.tryPlaceLock(world, pos, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private boolean tryPlaceLock(Level worldIn, BlockPos pos, Player entityplayer, InteractionHand hand) {
        ItemStack itemstack = entityplayer.m_21120_(hand);
        if (itemstack.m_41782_()) {
            String code;
            String string = code = itemstack.m_41783_().m_128425_("Storage_Lock", 8) ? itemstack.m_41783_().m_128461_("Storage_Lock") : "";
            if (!code.isEmpty()) {
                BlockState currentDoor = worldIn.m_8055_(pos);
                Block newDoor = this.getMatchingDoor(currentDoor.m_60734_());
                if (newDoor == Blocks.f_50016_) {
                    return false;
                }
                if (!entityplayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                worldIn.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)newDoor.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)currentDoor.m_61143_((Property)DoorBlock.f_52726_)))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)currentDoor.m_61143_((Property)DoorBlock.f_52727_)))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)currentDoor.m_61143_((Property)DoorBlock.f_52728_)))).m_61124_((Property)DoorBlock.f_52730_, (Comparable)((DoubleBlockHalf)currentDoor.m_61143_((Property)DoorBlock.f_52730_))), 3);
                worldIn.m_5594_(entityplayer, pos, SoundEvents.f_11748_, SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.nextFloat() * 0.1f + 0.9f);
                BaseLockedBlockEntity currentTE = (BaseLockedBlockEntity)worldIn.m_7702_(pos);
                currentTE.setLockCode(code);
                if (currentDoor.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
                    BlockState downState = worldIn.m_8055_(pos.m_7495_());
                    worldIn.m_7731_(pos.m_7495_(), (BlockState)((BlockState)((BlockState)((BlockState)newDoor.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)downState.m_61143_((Property)DoorBlock.f_52726_)))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)downState.m_61143_((Property)DoorBlock.f_52727_)))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)downState.m_61143_((Property)DoorBlock.f_52728_)))).m_61124_((Property)DoorBlock.f_52730_, (Comparable)((DoubleBlockHalf)downState.m_61143_((Property)DoorBlock.f_52730_))), 3);
                    BaseLockedBlockEntity downTE = (BaseLockedBlockEntity)worldIn.m_7702_(pos.m_7495_());
                    downTE.setLockCode(code);
                } else {
                    BlockState upState = worldIn.m_8055_(pos.m_7494_());
                    worldIn.m_7731_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)((BlockState)newDoor.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)upState.m_61143_((Property)DoorBlock.f_52726_)))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)upState.m_61143_((Property)DoorBlock.f_52727_)))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)upState.m_61143_((Property)DoorBlock.f_52728_)))).m_61124_((Property)DoorBlock.f_52730_, (Comparable)((DoubleBlockHalf)upState.m_61143_((Property)DoorBlock.f_52730_))), 3);
                    BaseLockedBlockEntity upTE = (BaseLockedBlockEntity)worldIn.m_7702_(pos.m_7494_());
                    upTE.setLockCode(code);
                }
                return true;
            }
        }
        return false;
    }
}

