/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.tileentity.BaseStorageTileEntity;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class BaseStorageBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final VoxelShape FAKE_SIDES_AND_BOTTOM = Block.func_208617_a((double)0.01, (double)0.01, (double)0.01, (double)16.0, (double)16.0, (double)16.0);

    public BaseStorageBlock(AbstractBlock.Properties properties) {
        super(properties.func_200948_a(3.0f, 5.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context == ISelectionContext.func_216377_a()) {
            return FAKE_SIDES_AND_BOTTOM;
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    protected boolean isInvalidBlock(IWorld world, BlockPos pos) {
        return !world.func_175623_d(pos) && world.func_180495_p(pos).func_200015_d((IBlockReader)world, pos);
    }

    protected boolean isDoorBlocked(IWorld world, BlockPos pos) {
        return this.isInvalidBlock(world, pos.func_177972_a((Direction)world.func_180495_p(pos).func_177229_b((Property)FACING)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f().func_176734_d();
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        BaseStorageTileEntity tileentity;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BaseStorageTileEntity && (tileentity = (BaseStorageTileEntity)te).isLocked() && !this.canAccess(worldIn, pos, player)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BaseStorageTileEntity && stack.func_82837_s()) {
            ((BaseStorageTileEntity)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof BaseStorageTileEntity) {
                BaseStorageTileEntity teStorage = (BaseStorageTileEntity)tileentity;
                if (teStorage.isLocked()) {
                    ItemStack lockStack = new ItemStack((IItemProvider)StorageItems.LOCKSMITH_LOCK.get());
                    CompoundNBT tag = new CompoundNBT();
                    new StorageLockCode(teStorage.getLockCode()).write(tag);
                    lockStack.func_77982_d(tag);
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)lockStack);
                }
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((BaseStorageTileEntity)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    protected boolean canBeLocked(World worldIn, BlockPos pos) {
        return !((BaseStorageTileEntity)worldIn.func_175625_s(pos)).isLocked();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        INamedContainerProvider inamedcontainerprovider;
        BaseStorageTileEntity teStorage;
        TileEntity tileentity;
        if (this.canBeLocked(worldIn, pos) && player.func_184586_b(handIn).func_77973_b() == StorageItems.LOCKSMITH_LOCK.get() && this.tryPlaceLock(worldIn, pos, player, handIn)) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && this.canAccess((IBlockReader)worldIn, pos, player) && (tileentity = worldIn.func_175625_s(pos)) instanceof BaseStorageTileEntity && (teStorage = (BaseStorageTileEntity)worldIn.func_175625_s(pos)).isLocked()) {
            ItemStack lockStack = new ItemStack((IItemProvider)StorageItems.LOCKSMITH_LOCK.get());
            CompoundNBT tag = new CompoundNBT();
            new StorageLockCode(teStorage.getLockCode()).write(tag);
            lockStack.func_77982_d(tag);
            if (this.removeLock(worldIn, pos, player)) {
                ItemEntity blockDropped = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), lockStack);
                if (!worldIn.field_72995_K) {
                    worldIn.func_217376_c((Entity)blockDropped);
                    if (!(player instanceof FakePlayer)) {
                        blockDropped.func_70100_b_(player);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        if (!this.isDoorBlocked((IWorld)worldIn, pos) && this.canAccess((IBlockReader)worldIn, pos, player) && !worldIn.field_72995_K && (inamedcontainerprovider = this.func_220052_b(state, worldIn, pos)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)inamedcontainerprovider, (BlockPos)pos);
            player.func_71029_a(this.getOpenStat());
        }
        return ActionResultType.SUCCESS;
    }

    protected Stat<ResourceLocation> getOpenStat() {
        return Stats.field_199092_j.func_199076_b((Object)Stats.field_188063_ac);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity instanceof INamedContainerProvider ? (INamedContainerProvider)tileentity : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private boolean removeLock(World worldIn, BlockPos pos, PlayerEntity entityplayer) {
        BaseStorageTileEntity tileentity = (BaseStorageTileEntity)worldIn.func_175625_s(pos);
        tileentity.setLockCode("");
        tileentity.func_145831_w().func_184133_a(entityplayer, tileentity.func_174877_v(), SoundEvents.field_187654_U, SoundCategory.BLOCKS, 0.5f, tileentity.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
        return true;
    }

    private boolean tryPlaceLock(World worldIn, BlockPos pos, PlayerEntity entityplayer, Hand hand) {
        BaseStorageTileEntity tileentity = (BaseStorageTileEntity)worldIn.func_175625_s(pos);
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (itemstack.func_77942_o()) {
            String code;
            String string = code = itemstack.func_77978_p().func_150297_b("Storage_Lock", 8) ? itemstack.func_77978_p().func_74779_i("Storage_Lock") : "";
            if (!code.isEmpty()) {
                if (!entityplayer.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                tileentity.setLockCode(code);
                tileentity.func_145831_w().func_184133_a(entityplayer, tileentity.func_174877_v(), SoundEvents.field_187654_U, SoundCategory.BLOCKS, 0.5f, tileentity.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                return true;
            }
        }
        return false;
    }

    private boolean canAccess(IBlockReader worldIn, BlockPos pos, PlayerEntity entityplayer) {
        BaseStorageTileEntity tileentity = (BaseStorageTileEntity)worldIn.func_175625_s(pos);
        if (tileentity.isLocked()) {
            for (int slot = 0; slot < entityplayer.field_71071_by.func_70302_i_(); ++slot) {
                String code;
                ItemStack itemstack = entityplayer.field_71071_by.func_70301_a(slot);
                if (itemstack.func_190926_b() || itemstack.func_77973_b() != StorageItems.LOCKSMITH_KEY.get() || !itemstack.func_77942_o()) continue;
                String string = code = itemstack.func_77978_p().func_150297_b("Storage_Lock", 8) ? itemstack.func_77978_p().func_74779_i("Storage_Lock") : "";
                if (code.isEmpty()) continue;
                return tileentity.getLockCode().equals(code);
            }
            return false;
        }
        return true;
    }
}

