/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.BaseStorageBlock;
import com.grim3212.assorted.storage.common.block.ObsidianSafeBlock;
import com.grim3212.assorted.storage.common.block.StorageBlocks;
import com.grim3212.assorted.storage.common.block.tileentity.GoldSafeTileEntity;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class GoldSafeBlock
extends BaseStorageBlock {
    public static final ResourceLocation CONTENTS = new ResourceLocation("assortedstorage", "contents");

    public GoldSafeBlock(AbstractBlock.Properties properties) {
        super(properties.func_235861_h_().func_200948_a(50.0f, 1200.0f));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GoldSafeTileEntity();
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ObsidianSafeBlock.SAFE_SHAPE;
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof GoldSafeTileEntity) {
                GoldSafeTileEntity goldsafetileentity = (GoldSafeTileEntity)tileentity;
                if (goldsafetileentity.isLocked()) {
                    ItemStack lockStack = new ItemStack((IItemProvider)StorageItems.LOCKSMITH_LOCK.get());
                    CompoundNBT tag = new CompoundNBT();
                    new StorageLockCode(goldsafetileentity.getLockCode()).write(tag);
                    lockStack.func_77982_d(tag);
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)lockStack);
                }
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            if (!(!state.hasTileEntity() || state.func_203425_a(newState.func_177230_c()) && newState.hasTileEntity())) {
                worldIn.func_175713_t(pos);
            }
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.func_185473_a(worldIn, pos, state);
        GoldSafeTileEntity goldsafetileentity = (GoldSafeTileEntity)worldIn.func_175625_s(pos);
        CompoundNBT compoundnbt = goldsafetileentity.saveToNbt(new CompoundNBT());
        if (!compoundnbt.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemstack;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof GoldSafeTileEntity) {
            GoldSafeTileEntity goldsafetileentity = (GoldSafeTileEntity)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_() && !goldsafetileentity.func_191420_l()) {
                ItemStack itemstack = new ItemStack((IItemProvider)StorageBlocks.GOLD_SAFE.get());
                CompoundNBT compoundnbt = goldsafetileentity.saveToNbt(new CompoundNBT());
                if (!compoundnbt.isEmpty()) {
                    itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                }
                if (goldsafetileentity.func_145818_k_()) {
                    itemstack.func_200302_a(goldsafetileentity.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof GoldSafeTileEntity) {
            GoldSafeTileEntity goldsafetileentity = (GoldSafeTileEntity)tileentity;
            builder = builder.func_216017_a(CONTENTS, (context, stackConsumer) -> {
                for (int i = 0; i < goldsafetileentity.func_70302_i_(); ++i) {
                    stackConsumer.accept(goldsafetileentity.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            if (compoundnbt.func_150297_b("LootTable", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("???????"));
            }
            if (compoundnbt.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    IFormattableTextComponent iformattabletextcomponent = itemstack.func_200301_q().func_230532_e_();
                    iformattabletextcomponent.func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E()));
                    tooltip.add((ITextComponent)iformattabletextcomponent);
                }
                if (j - i > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_240699_a_(TextFormatting.ITALIC));
                }
            }
        }
    }
}

