/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.tileentity.BaseLockedTileEntity;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class LockedDoorBlock
extends DoorBlock {
    private final Block parent;

    public LockedDoorBlock(Block parent, AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176520_a, (Comparable)Direction.NORTH)).func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)field_176522_N, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
        this.parent = parent;
    }

    public LockedDoorBlock(ResourceLocation parent, AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176520_a, (Comparable)Direction.NORTH)).func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)field_176522_N, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
        this.parent = (Block)Registry.field_212618_g.func_82594_a(parent);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.parent.getPickBlock(state, target, world, pos, player);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public void func_242663_a(World worldIn, BlockState state, BlockPos pos, boolean open) {
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b((Property)field_176523_O);
        if (facing.func_176740_k() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            boolean isValidBlock;
            boolean bl = isValidBlock = doubleblockhalf == DoubleBlockHalf.UPPER ? worldIn.func_180495_p(currentPos.func_177977_b()).func_177230_c() instanceof DoorBlock : worldIn.func_180495_p(currentPos.func_177984_a()).func_177230_c() instanceof DoorBlock;
            return facingState.func_203425_a((Block)this) && facingState.func_177229_b((Property)field_176523_O) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a((Property)field_176520_a, facingState.func_177229_b((Property)field_176520_a))).func_206870_a((Property)field_176519_b, facingState.func_177229_b((Property)field_176519_b))).func_206870_a((Property)field_176521_M, facingState.func_177229_b((Property)field_176521_M))).func_206870_a((Property)field_176522_N, facingState.func_177229_b((Property)field_176522_N)) : (isValidBlock ? stateIn : Blocks.field_150350_a.func_176223_P());
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BaseLockedTileEntity teStorage;
        TileEntity tileentity;
        if (player.func_225608_bj_() && this.canAccess((IBlockReader)worldIn, pos, player) && (tileentity = worldIn.func_175625_s(pos)) instanceof BaseLockedTileEntity && (teStorage = (BaseLockedTileEntity)worldIn.func_175625_s(pos)).isLocked() && this.removeLock(worldIn, pos, player)) {
            return ActionResultType.SUCCESS;
        }
        if (this.canAccess((IBlockReader)worldIn, pos, player)) {
            state = (BlockState)state.func_235896_a_((Property)field_176519_b);
            worldIn.func_180501_a(pos, state, 10);
            worldIn.func_217378_a(player, (Boolean)state.func_177229_b((Property)field_176519_b) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        BaseLockedTileEntity tileentity;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BaseLockedTileEntity && (tileentity = (BaseLockedTileEntity)te).isLocked() && !this.canAccess(worldIn, pos, player)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            BaseLockedTileEntity teStorage;
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof BaseLockedTileEntity && (teStorage = (BaseLockedTileEntity)tileentity).isLocked() && state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.UPPER) {
                ItemStack lockStack = new ItemStack((IItemProvider)StorageItems.LOCKSMITH_LOCK.get());
                CompoundNBT tag = new CompoundNBT();
                new StorageLockCode(teStorage.getLockCode()).write(tag);
                lockStack.func_77982_d(tag);
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)lockStack);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BaseLockedTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    private boolean removeLock(World worldIn, BlockPos pos, PlayerEntity entityplayer) {
        BlockState state = worldIn.func_180495_p(pos);
        Direction dir = (Direction)state.func_177229_b((Property)field_176520_a);
        boolean open = (Boolean)state.func_177229_b((Property)field_176519_b);
        DoorHingeSide hinge = (DoorHingeSide)state.func_177229_b((Property)field_176521_M);
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b((Property)field_176523_O);
        BlockState toPlace = (BlockState)((BlockState)((BlockState)this.parent.func_176223_P().func_206870_a((Property)field_176520_a, (Comparable)dir)).func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(open))).func_206870_a((Property)field_176521_M, (Comparable)hinge);
        worldIn.func_180501_a(pos, (BlockState)toPlace.func_206870_a((Property)field_176523_O, (Comparable)half), 3);
        worldIn.func_184133_a(entityplayer, pos, SoundEvents.field_187654_U, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
        if (half == DoubleBlockHalf.UPPER) {
            worldIn.func_180501_a(pos.func_177977_b(), (BlockState)toPlace.func_206870_a((Property)field_176523_O, (Comparable)DoubleBlockHalf.LOWER), 3);
        } else {
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)toPlace.func_206870_a((Property)field_176523_O, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
        return true;
    }

    private boolean canAccess(IBlockReader worldIn, BlockPos pos, PlayerEntity entityplayer) {
        BaseLockedTileEntity tileentity = (BaseLockedTileEntity)worldIn.func_175625_s(pos);
        if (tileentity != null && tileentity.isLocked()) {
            for (int slot = 0; slot < entityplayer.field_71071_by.func_70302_i_(); ++slot) {
                String code;
                ItemStack itemstack = entityplayer.field_71071_by.func_70301_a(slot);
                if (itemstack.func_190926_b() || itemstack.func_77973_b() != StorageItems.LOCKSMITH_KEY.get() || !itemstack.func_77942_o()) continue;
                String string = code = itemstack.func_77978_p().func_150297_b("Storage_Lock", 8) ? itemstack.func_77978_p().func_74779_i("Storage_Lock") : "";
                if (code.isEmpty()) continue;
                return tileentity.getLockCode().equals(code);
            }
            return false;
        }
        return true;
    }
}

