/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.BaseStorageBlock;
import com.grim3212.assorted.storage.common.block.ObsidianSafeBlock;
import com.grim3212.assorted.storage.common.block.tileentity.BaseStorageTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.LockerTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LockerBlock
extends BaseStorageBlock {
    public LockerBlock(AbstractBlock.Properties properties) {
        super(properties.func_235861_h_().func_200948_a(3.0f, 6.0f));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new LockerTileEntity();
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (LockerBlock.isDualLocker(worldIn, pos) && LockerBlock.isTopLocker(worldIn, pos)) {
            return super.func_220053_a(state, worldIn, pos, context);
        }
        return ObsidianSafeBlock.SAFE_SHAPE;
    }

    @Override
    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        if (LockerBlock.isDualLocker(worldIn, pos) && LockerBlock.isTopLocker(worldIn, pos)) {
            return super.func_180647_a(state, player, worldIn, pos.func_177977_b());
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177979_c(2)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this) {
            return;
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileentitytop = worldIn.func_175625_s(pos.func_177984_a());
        if (LockerBlock.isBottomLocker((IBlockReader)worldIn, pos) && tileentitytop != null && tileentitytop instanceof BaseStorageTileEntity) {
            BaseStorageTileEntity tileentitythis = (BaseStorageTileEntity)worldIn.func_175625_s(pos);
            BaseStorageTileEntity tileentitystoragetop = (BaseStorageTileEntity)tileentitytop;
            if (tileentitystoragetop.isLocked()) {
                tileentitythis.setLockCode(tileentitystoragetop.getLockCode());
                tileentitystoragetop.setLockCode(null);
            }
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (LockerBlock.isDualLocker((IBlockReader)worldIn, pos)) {
            if (LockerBlock.isTopLocker((IBlockReader)worldIn, pos)) {
                return this.func_225533_a_(worldIn.func_180495_p(pos.func_177977_b()), worldIn, pos.func_177977_b(), player, handIn, hit);
            }
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public static boolean isDualLocker(IBlockReader world, BlockPos pos) {
        return LockerBlock.isTopLocker(world, pos) || LockerBlock.isBottomLocker(world, pos);
    }

    public static boolean isTopLocker(IBlockReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()) == world.func_180495_p(pos);
    }

    public static boolean isBottomLocker(IBlockReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()) == world.func_180495_p(pos);
    }
}

