/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.grim3212.assorted.storage.common.block.tileentity.BaseLockedTileEntity;
import com.grim3212.assorted.storage.common.item.StorageItems;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class QuartzDoorBlock
extends DoorBlock {
    public static final BooleanProperty LOCKED = BooleanProperty.func_177716_a((String)"locked");

    public QuartzDoorBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176520_a, (Comparable)Direction.NORTH)).func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)field_176522_N, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176523_O, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean isLocked = !this.canBeLocked(worldIn, currentPos);
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b((Property)field_176523_O);
        if (facing.func_176740_k() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.func_203425_a((Block)this) && facingState.func_177229_b((Property)field_176523_O) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a((Property)field_176520_a, facingState.func_177229_b((Property)field_176520_a))).func_206870_a((Property)field_176519_b, facingState.func_177229_b((Property)field_176519_b))).func_206870_a((Property)field_176521_M, facingState.func_177229_b((Property)field_176521_M))).func_206870_a((Property)field_176522_N, facingState.func_177229_b((Property)field_176522_N))).func_206870_a((Property)LOCKED, (Comparable)Boolean.valueOf(isLocked)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : (BlockState)stateIn.func_206870_a((Property)LOCKED, (Comparable)Boolean.valueOf(isLocked));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176523_O, field_176520_a, field_176519_b, field_176521_M, field_176522_N, LOCKED});
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        boolean bl = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177972_a(state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (blockIn != this && flag != (Boolean)state.func_177229_b((Property)field_176522_N) && this.canBeLocked((IWorld)worldIn, pos)) {
            if (flag != (Boolean)state.func_177229_b((Property)field_176519_b)) {
                this.playSound(worldIn, pos, flag);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)field_176522_N, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BaseLockedTileEntity teStorage;
        TileEntity tileentity;
        if (this.canBeLocked((IWorld)worldIn, pos) && player.func_184586_b(handIn).func_77973_b() == StorageItems.LOCKSMITH_LOCK.get() && this.tryPlaceLock(worldIn, pos, player, handIn)) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && this.canAccess((IBlockReader)worldIn, pos, player) && (tileentity = worldIn.func_175625_s(pos)) instanceof BaseLockedTileEntity && (teStorage = (BaseLockedTileEntity)worldIn.func_175625_s(pos)).isLocked()) {
            ItemStack lockStack = new ItemStack((IItemProvider)StorageItems.LOCKSMITH_LOCK.get());
            CompoundNBT tag = new CompoundNBT();
            new StorageLockCode(teStorage.getLockCode()).write(tag);
            lockStack.func_77982_d(tag);
            if (this.removeLock(worldIn, pos, player)) {
                ItemEntity blockDropped = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), lockStack);
                if (!worldIn.field_72995_K) {
                    worldIn.func_217376_c((Entity)blockDropped);
                    if (!(player instanceof FakePlayer)) {
                        blockDropped.func_70100_b_(player);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        if (this.canAccess((IBlockReader)worldIn, pos, player)) {
            state = (BlockState)state.func_235896_a_((Property)field_176519_b);
            worldIn.func_180501_a(pos, state, 10);
            worldIn.func_217378_a(player, (Boolean)state.func_177229_b((Property)field_176519_b) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_242663_a(World worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.func_203425_a((Block)this) && (Boolean)state.func_177229_b((Property)field_176519_b) != open && !((Boolean)state.func_177229_b((Property)LOCKED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176519_b, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(worldIn, pos, open);
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        BaseLockedTileEntity tileentity;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BaseLockedTileEntity && (tileentity = (BaseLockedTileEntity)te).isLocked() && !this.canAccess(worldIn, pos, player)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            BaseLockedTileEntity teStorage;
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof BaseLockedTileEntity && (teStorage = (BaseLockedTileEntity)tileentity).isLocked() && state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.UPPER) {
                ItemStack lockStack = new ItemStack((IItemProvider)StorageItems.LOCKSMITH_LOCK.get());
                CompoundNBT tag = new CompoundNBT();
                new StorageLockCode(teStorage.getLockCode()).write(tag);
                lockStack.func_77982_d(tag);
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)lockStack);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private void playSound(World worldIn, BlockPos pos, boolean isOpening) {
        worldIn.func_217378_a((PlayerEntity)null, isOpening ? this.getOpenSound() : this.getCloseSound(), pos, 0);
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BaseLockedTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected boolean canBeLocked(IWorld worldIn, BlockPos pos) {
        return !((BaseLockedTileEntity)worldIn.func_175625_s(pos)).isLocked();
    }

    private boolean removeLock(World worldIn, BlockPos pos, PlayerEntity entityplayer) {
        BaseLockedTileEntity tileentity = (BaseLockedTileEntity)worldIn.func_175625_s(pos);
        tileentity.setLockCode("");
        tileentity.func_145831_w().func_184133_a(entityplayer, tileentity.func_174877_v(), SoundEvents.field_187654_U, SoundCategory.BLOCKS, 0.5f, tileentity.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
        BlockState state = worldIn.func_180495_p(pos);
        BlockState blockstate = Block.func_199770_b((BlockState)state, (IWorld)worldIn, (BlockPos)pos);
        Block.func_196263_a((BlockState)state, (BlockState)blockstate, (IWorld)worldIn, (BlockPos)pos, (int)3);
        if (worldIn.func_180495_p(pos).func_177229_b((Property)field_176523_O) == DoubleBlockHalf.UPPER) {
            BaseLockedTileEntity tileentityLower = (BaseLockedTileEntity)worldIn.func_175625_s(pos.func_177977_b());
            if (tileentityLower != null) {
                tileentityLower.setLockCode("");
            }
            BlockState stateLower = worldIn.func_180495_p(pos.func_177977_b());
            BlockState blockstateLower = Block.func_199770_b((BlockState)stateLower, (IWorld)worldIn, (BlockPos)pos.func_177977_b());
            Block.func_196263_a((BlockState)stateLower, (BlockState)blockstateLower, (IWorld)worldIn, (BlockPos)pos.func_177977_b(), (int)3);
        } else {
            BaseLockedTileEntity tileentityUpper = (BaseLockedTileEntity)worldIn.func_175625_s(pos.func_177984_a());
            if (tileentityUpper != null) {
                tileentityUpper.setLockCode("");
            }
            BlockState stateUpper = worldIn.func_180495_p(pos.func_177984_a());
            BlockState blockstateUpper = Block.func_199770_b((BlockState)stateUpper, (IWorld)worldIn, (BlockPos)pos.func_177984_a());
            Block.func_196263_a((BlockState)stateUpper, (BlockState)blockstateUpper, (IWorld)worldIn, (BlockPos)pos.func_177984_a(), (int)3);
        }
        return true;
    }

    private boolean tryPlaceLock(World worldIn, BlockPos pos, PlayerEntity entityplayer, Hand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (itemstack.func_77942_o()) {
            String code;
            String string = code = itemstack.func_77978_p().func_150297_b("Storage_Lock", 8) ? itemstack.func_77978_p().func_74779_i("Storage_Lock") : "";
            if (!code.isEmpty()) {
                BaseLockedTileEntity tileentity = (BaseLockedTileEntity)worldIn.func_175625_s(pos);
                if (!entityplayer.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                tileentity.setLockCode(code);
                tileentity.func_145831_w().func_184133_a(entityplayer, tileentity.func_174877_v(), SoundEvents.field_187654_U, SoundCategory.BLOCKS, 0.5f, tileentity.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                BlockState state = worldIn.func_180495_p(pos);
                BlockState blockstate = Block.func_199770_b((BlockState)state, (IWorld)worldIn, (BlockPos)pos);
                Block.func_196263_a((BlockState)state, (BlockState)blockstate, (IWorld)worldIn, (BlockPos)pos, (int)3);
                if (state.func_177229_b((Property)field_176523_O) == DoubleBlockHalf.UPPER) {
                    BaseLockedTileEntity tileentityLower = (BaseLockedTileEntity)worldIn.func_175625_s(pos.func_177977_b());
                    if (tileentityLower != null) {
                        tileentityLower.setLockCode(code);
                    }
                    BlockState stateLower = worldIn.func_180495_p(pos.func_177977_b());
                    BlockState blockstateLower = Block.func_199770_b((BlockState)stateLower, (IWorld)worldIn, (BlockPos)pos.func_177977_b());
                    Block.func_196263_a((BlockState)stateLower, (BlockState)blockstateLower, (IWorld)worldIn, (BlockPos)pos.func_177977_b(), (int)3);
                } else {
                    BaseLockedTileEntity tileentityUpper = (BaseLockedTileEntity)worldIn.func_175625_s(pos.func_177984_a());
                    if (tileentityUpper != null) {
                        tileentityUpper.setLockCode(code);
                    }
                    BlockState stateUpper = worldIn.func_180495_p(pos.func_177984_a());
                    BlockState blockstateUpper = Block.func_199770_b((BlockState)stateUpper, (IWorld)worldIn, (BlockPos)pos.func_177984_a());
                    Block.func_196263_a((BlockState)stateUpper, (BlockState)blockstateUpper, (IWorld)worldIn, (BlockPos)pos.func_177984_a(), (int)3);
                }
                return true;
            }
        }
        return false;
    }

    private boolean canAccess(IBlockReader worldIn, BlockPos pos, PlayerEntity entityplayer) {
        BaseLockedTileEntity tileentity = (BaseLockedTileEntity)worldIn.func_175625_s(pos);
        if (tileentity.isLocked()) {
            for (int slot = 0; slot < entityplayer.field_71071_by.func_70302_i_(); ++slot) {
                String code;
                ItemStack itemstack = entityplayer.field_71071_by.func_70301_a(slot);
                if (itemstack.func_190926_b() || itemstack.func_77973_b() != StorageItems.LOCKSMITH_KEY.get() || !itemstack.func_77942_o()) continue;
                String string = code = itemstack.func_77978_p().func_150297_b("Storage_Lock", 8) ? itemstack.func_77978_p().func_74779_i("Storage_Lock") : "";
                if (code.isEmpty()) continue;
                return tileentity.getLockCode().equals(code);
            }
            return false;
        }
        return true;
    }
}

