/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block;

import com.google.common.collect.Sets;
import com.grim3212.assorted.storage.AssortedStorage;
import com.grim3212.assorted.storage.client.tileentity.StorageItemStackRenderer;
import com.grim3212.assorted.storage.common.block.GlassCabinetBlock;
import com.grim3212.assorted.storage.common.block.GoldSafeBlock;
import com.grim3212.assorted.storage.common.block.ItemTowerBlock;
import com.grim3212.assorted.storage.common.block.LockedDoorBlock;
import com.grim3212.assorted.storage.common.block.LockerBlock;
import com.grim3212.assorted.storage.common.block.LocksmithWorkbenchBlock;
import com.grim3212.assorted.storage.common.block.ObsidianSafeBlock;
import com.grim3212.assorted.storage.common.block.WarehouseCrateBlock;
import com.grim3212.assorted.storage.common.block.WoodCabinetBlock;
import com.grim3212.assorted.storage.common.block.tileentity.GlassCabinetTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.GoldSafeTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.ItemTowerTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.LockerTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.ObsidianSafeTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.WarehouseCrateTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.WoodCabinetTileEntity;
import com.grim3212.assorted.storage.common.item.LockerItem;
import com.grim3212.assorted.storage.common.item.StorageItems;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StorageBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"assortedstorage");
    public static final DeferredRegister<Item> ITEMS = StorageItems.ITEMS;
    public static final RegistryObject<LocksmithWorkbenchBlock> LOCKSMITH_WORKBENCH = StorageBlocks.register("locksmith_workbench", () -> new LocksmithWorkbenchBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<WoodCabinetBlock> WOOD_CABINET = StorageBlocks.register("wood_cabinet", () -> new WoodCabinetBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a)), () -> StorageBlocks.woodCabinetRenderer());
    public static final RegistryObject<GlassCabinetBlock> GLASS_CABINET = StorageBlocks.register("glass_cabinet", () -> new GlassCabinetBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a)), () -> StorageBlocks.glassCabinetRenderer());
    public static final RegistryObject<GoldSafeBlock> GOLD_SAFE = StorageBlocks.register("gold_safe", () -> new GoldSafeBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e)), () -> StorageBlocks.goldSafeRenderer());
    public static final RegistryObject<ObsidianSafeBlock> OBSIDIAN_SAFE = StorageBlocks.register("obsidian_safe", () -> new ObsidianSafeBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d)), () -> StorageBlocks.obsidianSafeRenderer());
    public static final RegistryObject<LockerBlock> LOCKER = StorageBlocks.registerWithItem("locker", () -> new LockerBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e)), StorageBlocks.lockerItem());
    public static final RegistryObject<ItemTowerBlock> ITEM_TOWER = StorageBlocks.register("item_tower", () -> new ItemTowerBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e)), () -> StorageBlocks.itemTowerRenderer());
    public static final RegistryObject<WarehouseCrateBlock> OAK_WAREHOUSE_CRATE = StorageBlocks.register("oak_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.field_227038_a_), () -> StorageBlocks.oakWarehouseCrateRenderer());
    public static final RegistryObject<WarehouseCrateBlock> BIRCH_WAREHOUSE_CRATE = StorageBlocks.register("birch_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.field_227040_c_), () -> StorageBlocks.birchWarehouseCrateRenderer());
    public static final RegistryObject<WarehouseCrateBlock> SPRUCE_WAREHOUSE_CRATE = StorageBlocks.register("spruce_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.field_227039_b_), () -> StorageBlocks.spruceWarehouseCrateRenderer());
    public static final RegistryObject<WarehouseCrateBlock> ACACIA_WAREHOUSE_CRATE = StorageBlocks.register("acacia_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.field_227041_d_), () -> StorageBlocks.acaciaWarehouseCrateRenderer());
    public static final RegistryObject<WarehouseCrateBlock> DARK_OAK_WAREHOUSE_CRATE = StorageBlocks.register("dark_oak_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.field_227043_f_), () -> StorageBlocks.darkOakWarehouseCrateRenderer());
    public static final RegistryObject<WarehouseCrateBlock> JUNGLE_WAREHOUSE_CRATE = StorageBlocks.register("jungle_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.field_227042_e_), () -> StorageBlocks.jungleWarehouseCrateRenderer());
    public static final RegistryObject<WarehouseCrateBlock> WARPED_WAREHOUSE_CRATE = StorageBlocks.register("warped_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.field_235924_h_), () -> StorageBlocks.warpedWarehouseCrateRenderer());
    public static final RegistryObject<WarehouseCrateBlock> CRIMSON_WAREHOUSE_CRATE = StorageBlocks.register("crimson_warehouse_crate", () -> new WarehouseCrateBlock(WoodType.field_235923_g_), () -> StorageBlocks.crimsonWarehouseCrateRenderer());
    public static final RegistryObject<LockedDoorBlock> LOCKED_OAK_DOOR = StorageBlocks.registerNoItem("locked_oak_door", () -> new LockedDoorBlock(Blocks.field_180413_ao, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_SPRUCE_DOOR = StorageBlocks.registerNoItem("locked_spruce_door", () -> new LockedDoorBlock(Blocks.field_180414_ap, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151654_J).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_BIRCH_DOOR = StorageBlocks.registerNoItem("locked_birch_door", () -> new LockedDoorBlock(Blocks.field_180412_aq, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151658_d).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_JUNGLE_DOOR = StorageBlocks.registerNoItem("locked_jungle_door", () -> new LockedDoorBlock(Blocks.field_180411_ar, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151664_l).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_ACACIA_DOOR = StorageBlocks.registerNoItem("locked_acacia_door", () -> new LockedDoorBlock(Blocks.field_180410_as, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151676_q).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_DARK_OAK_DOOR = StorageBlocks.registerNoItem("locked_dark_oak_door", () -> new LockedDoorBlock(Blocks.field_180409_at, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151650_B).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_CRIMSON_DOOR = StorageBlocks.registerNoItem("locked_crimson_door", () -> new LockedDoorBlock(Blocks.field_235360_mS_, AbstractBlock.Properties.func_200949_a((Material)Material.field_237214_y_, (MaterialColor)MaterialColor.field_241540_ac_).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_WARPED_DOOR = StorageBlocks.registerNoItem("locked_warped_door", () -> new LockedDoorBlock(Blocks.field_235361_mT_, AbstractBlock.Properties.func_200949_a((Material)Material.field_237214_y_, (MaterialColor)MaterialColor.field_241543_af_).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_IRON_DOOR = StorageBlocks.registerNoItem("locked_iron_door", () -> new LockedDoorBlock(Blocks.field_150454_av, AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151668_h).func_235861_h_().func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()));
    public static final RegistryObject<LockedDoorBlock> LOCKED_QUARTZ_DOOR = StorageBlocks.registerNoItem("locked_quartz_door", () -> new LockedDoorBlock(new ResourceLocation("assorteddecor:quartz_door"), AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151677_p).func_235861_h_().func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()));

    public static Set<Block> lockedDoors() {
        return Sets.newHashSet((Object[])new Block[]{(Block)LOCKED_OAK_DOOR.get(), (Block)LOCKED_SPRUCE_DOOR.get(), (Block)LOCKED_BIRCH_DOOR.get(), (Block)LOCKED_JUNGLE_DOOR.get(), (Block)LOCKED_ACACIA_DOOR.get(), (Block)LOCKED_DARK_OAK_DOOR.get(), (Block)LOCKED_CRIMSON_DOOR.get(), (Block)LOCKED_WARPED_DOOR.get(), (Block)LOCKED_IRON_DOOR.get(), (Block)LOCKED_QUARTZ_DOOR.get()});
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        return StorageBlocks.register(name, sup, (RegistryObject<T> block) -> StorageBlocks.item((RegistryObject<? extends Block>)block));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Supplier<Callable<ItemStackTileEntityRenderer>> renderMethod) {
        return StorageBlocks.register(name, sup, (RegistryObject<T> block) -> StorageBlocks.item((RegistryObject<? extends Block>)block, renderMethod));
    }

    private static <T extends Block> RegistryObject<T> registerWithItem(String name, Supplier<? extends T> sup, Supplier<BlockItem> blockItem) {
        return StorageBlocks.register(name, sup, (RegistryObject<T> block) -> blockItem);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = StorageBlocks.registerNoItem(name, sup);
        ITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(AssortedStorage.ASSORTED_STORAGE_ITEM_GROUP));
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, Supplier<Callable<ItemStackTileEntityRenderer>> renderMethod) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(AssortedStorage.ASSORTED_STORAGE_ITEM_GROUP).setISTER(renderMethod));
    }

    private static Supplier<BlockItem> lockerItem() {
        return () -> new LockerItem(new Item.Properties().func_200916_a(AssortedStorage.ASSORTED_STORAGE_ITEM_GROUP).setISTER(() -> StorageBlocks.lockerRenderer()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> woodCabinetRenderer() {
        return () -> new StorageItemStackRenderer<WoodCabinetTileEntity>(WoodCabinetTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> glassCabinetRenderer() {
        return () -> new StorageItemStackRenderer<GlassCabinetTileEntity>(GlassCabinetTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> oakWarehouseCrateRenderer() {
        return () -> new StorageItemStackRenderer<WarehouseCrateTileEntity>(() -> new WarehouseCrateTileEntity((Block)OAK_WAREHOUSE_CRATE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> birchWarehouseCrateRenderer() {
        return () -> new StorageItemStackRenderer<WarehouseCrateTileEntity>(() -> new WarehouseCrateTileEntity((Block)BIRCH_WAREHOUSE_CRATE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> spruceWarehouseCrateRenderer() {
        return () -> new StorageItemStackRenderer<WarehouseCrateTileEntity>(() -> new WarehouseCrateTileEntity((Block)SPRUCE_WAREHOUSE_CRATE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> acaciaWarehouseCrateRenderer() {
        return () -> new StorageItemStackRenderer<WarehouseCrateTileEntity>(() -> new WarehouseCrateTileEntity((Block)ACACIA_WAREHOUSE_CRATE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> darkOakWarehouseCrateRenderer() {
        return () -> new StorageItemStackRenderer<WarehouseCrateTileEntity>(() -> new WarehouseCrateTileEntity((Block)DARK_OAK_WAREHOUSE_CRATE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> jungleWarehouseCrateRenderer() {
        return () -> new StorageItemStackRenderer<WarehouseCrateTileEntity>(() -> new WarehouseCrateTileEntity((Block)JUNGLE_WAREHOUSE_CRATE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> warpedWarehouseCrateRenderer() {
        return () -> new StorageItemStackRenderer<WarehouseCrateTileEntity>(() -> new WarehouseCrateTileEntity((Block)WARPED_WAREHOUSE_CRATE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> crimsonWarehouseCrateRenderer() {
        return () -> new StorageItemStackRenderer<WarehouseCrateTileEntity>(() -> new WarehouseCrateTileEntity((Block)CRIMSON_WAREHOUSE_CRATE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> goldSafeRenderer() {
        return () -> new StorageItemStackRenderer<GoldSafeTileEntity>(GoldSafeTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> obsidianSafeRenderer() {
        return () -> new StorageItemStackRenderer<ObsidianSafeTileEntity>(ObsidianSafeTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> lockerRenderer() {
        return () -> new StorageItemStackRenderer<LockerTileEntity>(LockerTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> itemTowerRenderer() {
        return () -> new StorageItemStackRenderer<ItemTowerTileEntity>(ItemTowerTileEntity::new);
    }
}

