/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block.tileentity;

import com.grim3212.assorted.storage.common.block.BaseStorageBlock;
import com.grim3212.assorted.storage.common.block.tileentity.IStorage;
import com.grim3212.assorted.storage.common.inventory.StorageContainer;
import com.grim3212.assorted.storage.common.util.StorageLockCode;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@OnlyIn(value=Dist.CLIENT, _interface=IStorage.class)
public abstract class BaseStorageTileEntity
extends TileEntity
implements ISidedInventory,
INamedContainerProvider,
INameable,
IStorage,
ITickableTileEntity {
    private NonNullList<ItemStack> chestContents;
    protected int numPlayersUsing;
    private int ticksSinceSync;
    protected float rotation;
    protected float prevRotation;
    private StorageLockCode lockCode = StorageLockCode.EMPTY_CODE;
    private ITextComponent customName;
    private LazyOptional<?> storageItemHandler = LazyOptional.of(() -> this.createSidedHandler());
    protected static final int[] DEFAULT_SLOTS = IntStream.range(0, 27).toArray();

    protected BaseStorageTileEntity(TileEntityType<?> typeIn) {
        this(typeIn, 27);
    }

    protected BaseStorageTileEntity(TileEntityType<?> typeIn, int inventorySize) {
        super(typeIn);
        this.chestContents = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
    }

    public boolean isLocked() {
        return this.lockCode != null && this.lockCode != StorageLockCode.EMPTY_CODE;
    }

    public String getLockCode() {
        return this.lockCode.getLockCode();
    }

    public void setLockCode(String s) {
        this.lockCode = s == null || s.isEmpty() ? StorageLockCode.EMPTY_CODE : new StorageLockCode(s);
    }

    public int func_70302_i_() {
        return this.getItems().size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.chestContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected abstract ITextComponent getDefaultName();

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        this.numPlayersUsing = BaseStorageTileEntity.getNumberOfPlayersUsing(this.field_145850_b, this, this.ticksSinceSync, i, j, k, this.numPlayersUsing);
        this.prevRotation = this.rotation;
        if (this.numPlayersUsing > 0 && this.rotation == 0.0f) {
            this.playSound(SoundEvents.field_187657_V);
        }
        if (this.numPlayersUsing == 0 && this.rotation > 0.0f || this.numPlayersUsing > 0 && this.rotation < 1.0f) {
            float f1 = this.rotation;
            this.rotation = this.numPlayersUsing > 0 ? (this.rotation += 0.1f) : (this.rotation -= 0.1f);
            if (this.rotation > 1.0f) {
                this.rotation = 1.0f;
            }
            if (this.rotation < 0.5f && f1 >= 0.5f) {
                this.playSound(SoundEvents.field_187651_T);
            }
            if (this.rotation < 0.0f) {
                this.rotation = 0.0f;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getRotation(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevRotation, (float)this.rotation);
    }

    public static int getNumberOfPlayersUsing(World worldIn, BaseStorageTileEntity lockableTileEntity, int ticksSinceSync, int x, int y, int z, int numPlayersUsing) {
        if (!worldIn.field_72995_K && numPlayersUsing != 0 && (ticksSinceSync + x + y + z) % 200 == 0) {
            numPlayersUsing = BaseStorageTileEntity.getNumberOfPlayersUsing(worldIn, lockableTileEntity, x, y, z);
        }
        return numPlayersUsing;
    }

    public static int getNumberOfPlayersUsing(World world, BaseStorageTileEntity lockableTileEntity, int x, int y, int z) {
        int i = 0;
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            if (!(playerentity.field_71070_bA instanceof StorageContainer)) continue;
            ++i;
        }
        return i;
    }

    private void playSound(SoundEvent soundIn) {
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184148_a((PlayerEntity)null, d0, d1, d2, soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BaseStorageBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.chestContents;
    }

    public abstract Block getBlockToUse();

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.chestContents);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("CustomName"));
        }
        this.readPacketNBT(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.chestContents);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        this.writePacketNBT(compound);
        return compound;
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.chestContents, (boolean)false);
        return compound;
    }

    public void writePacketNBT(CompoundNBT cmp) {
        this.lockCode.write(cmp);
    }

    public void readPacketNBT(CompoundNBT cmp) {
        this.lockCode = StorageLockCode.read(cmp);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.writePacketNBT(nbtTagCompound);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readPacketNBT(pkt.func_148857_g());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.storageItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected IItemHandler createSidedHandler() {
        return new SidedInvWrapper((ISidedInventory)this, null);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.storageItemHandler.invalidate();
    }

    public void func_174888_l() {
        this.getItems().clear();
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.getItems(), (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getItems().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public int[] func_180463_a(Direction side) {
        return DEFAULT_SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return !this.isLocked();
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return !this.isLocked();
    }
}

