/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block.tileentity;

import com.grim3212.assorted.storage.client.model.ItemTowerModel;
import com.grim3212.assorted.storage.common.block.StorageBlocks;
import com.grim3212.assorted.storage.common.block.tileentity.BaseStorageTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.StorageTileEntityTypes;
import com.grim3212.assorted.storage.common.inventory.ItemTowerContainer;
import com.grim3212.assorted.storage.common.inventory.ItemTowerInventory;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ItemTowerTileEntity
extends BaseStorageTileEntity {
    @OnlyIn(value=Dist.CLIENT)
    public ItemTowerModel model;
    protected static final int[] ITEM_TOWER_SLOTS = IntStream.range(0, 18).toArray();
    private LazyOptional<?> itemTowerItemHandler = LazyOptional.of(() -> this.createSidedHandler());

    public ItemTowerTileEntity() {
        super((TileEntityType)StorageTileEntityTypes.ITEM_TOWER.get(), 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animate(int animId) {
        if (this.model == null) {
            this.model = new ItemTowerModel();
        }
        this.model.setAnimation(animId);
    }

    public Container createMenu(int windowId, PlayerInventory player, PlayerEntity playerEntity) {
        return ItemTowerContainer.createItemTowerContainer(windowId, player, (IInventory)new ItemTowerInventory(this.getItemTowers(), this.field_174879_c));
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("assortedstorage.container.item_tower");
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return ITEM_TOWER_SLOTS;
    }

    public NonNullList<ItemTowerTileEntity> getItemTowers() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        NonNullList itemTowers = NonNullList.func_191196_a();
        int downBlocks = 1;
        while (this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(downBlocks)) == state) {
            ++downBlocks;
        }
        int upBlocks = 1;
        BlockPos bottomPos = this.field_174879_c.func_177979_c(downBlocks);
        while (this.field_145850_b.func_180495_p(bottomPos.func_177981_b(upBlocks)) == state) {
            itemTowers.add((Object)((ItemTowerTileEntity)this.field_145850_b.func_175625_s(bottomPos.func_177981_b(upBlocks))));
            ++upBlocks;
        }
        return itemTowers;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemTowerItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected IItemHandler createSidedHandler() {
        return new SidedInvWrapper((ISidedInventory)new ItemTowerInventory(this.getItemTowers(), this.field_174879_c), null);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemTowerItemHandler.invalidate();
    }

    @Override
    public Block getBlockToUse() {
        return (Block)StorageBlocks.ITEM_TOWER.get();
    }
}

