/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.block.tileentity;

import com.grim3212.assorted.storage.common.block.StorageBlocks;
import com.grim3212.assorted.storage.common.block.tileentity.BaseStorageTileEntity;
import com.grim3212.assorted.storage.common.block.tileentity.StorageTileEntityTypes;
import com.grim3212.assorted.storage.common.inventory.DualLockerInventory;
import com.grim3212.assorted.storage.common.inventory.LockerContainer;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class LockerTileEntity
extends BaseStorageTileEntity {
    private LazyOptional<?> lockerItemHandler = LazyOptional.of(() -> this.createSidedHandler());
    protected static final int[] LOCKER_SLOTS = IntStream.range(0, 45).toArray();

    public LockerTileEntity() {
        super((TileEntityType)StorageTileEntityTypes.LOCKER.get(), 45);
    }

    public Container createMenu(int windowId, PlayerInventory player, PlayerEntity playerEntity) {
        TileEntity lockerUp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (lockerUp != null && lockerUp instanceof LockerTileEntity) {
            return LockerContainer.createDualLockerContainer(windowId, player, (IInventory)new DualLockerInventory(this, (LockerTileEntity)lockerUp));
        }
        return LockerContainer.createLockerContainer(windowId, player, (IInventory)this);
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("assortedstorage.container.locker");
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lockerItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected IItemHandler createSidedHandler() {
        TileEntity lockerUp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (lockerUp != null && lockerUp instanceof LockerTileEntity) {
            return new SidedInvWrapper((ISidedInventory)new DualLockerInventory(this, (LockerTileEntity)lockerUp), null);
        }
        TileEntity lockerDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (lockerDown != null && lockerDown instanceof LockerTileEntity) {
            return new SidedInvWrapper((ISidedInventory)new DualLockerInventory((LockerTileEntity)lockerDown, this), null);
        }
        return super.createSidedHandler();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.lockerItemHandler.invalidate();
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return LOCKER_SLOTS;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        TileEntity lockerDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (lockerDown != null && lockerDown instanceof LockerTileEntity) {
            return ((LockerTileEntity)lockerDown).func_180462_a(index, itemStackIn, direction);
        }
        return super.func_180462_a(index, itemStackIn, direction);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        TileEntity lockerDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (lockerDown != null && lockerDown instanceof LockerTileEntity) {
            return ((LockerTileEntity)lockerDown).func_180461_b(index, stack, direction);
        }
        return super.func_180461_b(index, stack, direction);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.hasUpperLocker() ? super.getRenderBoundingBox().func_72321_a(0.0, 1.0, 0.0) : super.getRenderBoundingBox();
    }

    public boolean isUpperLocker() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()) == this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public boolean hasUpperLocker() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()) == this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public LockerTileEntity getUpperLocker() {
        if (this.field_145850_b == null || !this.hasUpperLocker()) {
            return null;
        }
        return (LockerTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
    }

    public boolean isBottomLocker() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()) == this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public boolean hasBottomLocker() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()) == this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public LockerTileEntity getBottomLocker() {
        if (this.field_145850_b == null || !this.hasUpperLocker()) {
            return null;
        }
        return (LockerTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
    }

    @Override
    public Block getBlockToUse() {
        return (Block)StorageBlocks.LOCKER.get();
    }
}

