/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.grim3212.assorted.storage.common.block.GoldSafeBlock;
import com.grim3212.assorted.storage.common.block.StorageBlocks;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class StorageLootProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final List<Block> blocks = new ArrayList<Block>();

    public StorageLootProvider(DataGenerator generator) {
        this.generator = generator;
        this.blocks.add((Block)StorageBlocks.WOOD_CABINET.get());
        this.blocks.add((Block)StorageBlocks.GLASS_CABINET.get());
        this.blocks.add((Block)StorageBlocks.OBSIDIAN_SAFE.get());
        this.blocks.add((Block)StorageBlocks.LOCKER.get());
        this.blocks.add((Block)StorageBlocks.ITEM_TOWER.get());
        this.blocks.add((Block)StorageBlocks.LOCKSMITH_WORKBENCH.get());
        this.blocks.add((Block)StorageBlocks.OAK_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.BIRCH_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.SPRUCE_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.ACACIA_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.DARK_OAK_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.JUNGLE_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.WARPED_WAREHOUSE_CRATE.get());
        this.blocks.add((Block)StorageBlocks.CRIMSON_WAREHOUSE_CRATE.get());
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block block : this.blocks) {
            tables.put(block.getRegistryName(), StorageLootProvider.genRegular(block));
        }
        tables.put(StorageBlocks.GOLD_SAFE.getId(), StorageLootProvider.genInventoryStorage((Block)StorageBlocks.GOLD_SAFE.get()));
        for (Map.Entry entry : tables.entrySet()) {
            Path path = StorageLootProvider.getPath(this.generator.func_200391_b(), (ResourceLocation)entry.getKey());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)((LootTable.Builder)entry.getValue()).func_216039_a(LootParameterSets.field_216267_h).func_216038_b()), (Path)path);
        }
        this.door((Block)StorageBlocks.LOCKED_IRON_DOOR.get(), Blocks.field_150454_av, cache);
        this.door((Block)StorageBlocks.LOCKED_OAK_DOOR.get(), Blocks.field_180413_ao, cache);
        this.door((Block)StorageBlocks.LOCKED_SPRUCE_DOOR.get(), Blocks.field_180414_ap, cache);
        this.door((Block)StorageBlocks.LOCKED_BIRCH_DOOR.get(), Blocks.field_180412_aq, cache);
        this.door((Block)StorageBlocks.LOCKED_ACACIA_DOOR.get(), Blocks.field_180410_as, cache);
        this.door((Block)StorageBlocks.LOCKED_JUNGLE_DOOR.get(), Blocks.field_180411_ar, cache);
        this.door((Block)StorageBlocks.LOCKED_DARK_OAK_DOOR.get(), Blocks.field_180409_at, cache);
        this.door((Block)StorageBlocks.LOCKED_CRIMSON_DOOR.get(), Blocks.field_235360_mS_, cache);
        this.door((Block)StorageBlocks.LOCKED_WARPED_DOOR.get(), Blocks.field_235361_mT_, cache);
    }

    private void door(Block b, Block out, DirectoryCache cache) throws IOException {
        Path doorPath = StorageLootProvider.getPath(this.generator.func_200391_b(), b.getRegistryName());
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)StorageLootProvider.genDoor(b, out).func_216039_a(LootParameterSets.field_216267_h).func_216038_b()), (Path)doorPath);
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
    }

    private static LootTable.Builder genDoor(Block b, Block out) {
        BlockStateProperty.Builder halfCondition = BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
        LootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)out).func_212840_b_((ILootCondition.IBuilder)halfCondition);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genRegular(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genInventoryStorage(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)GoldSafeBlock.CONTENTS)));
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    public String func_200397_b() {
        return "Assorted Storage loot tables";
    }
}

