/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.inventory;

import com.grim3212.assorted.storage.common.block.tileentity.ItemTowerTileEntity;
import com.grim3212.assorted.storage.common.inventory.ItemTowerInventory;
import com.grim3212.assorted.storage.common.inventory.MoveableSlot;
import com.grim3212.assorted.storage.common.inventory.StorageContainerTypes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.IContainerFactory;

public class ItemTowerContainer
extends Container {
    private final IInventory inventory;

    public static ItemTowerContainer createItemTowerContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ItemTowerContainer((ContainerType)StorageContainerTypes.ITEM_TOWER.get(), windowId, playerInventory, inventory);
    }

    public ItemTowerContainer(ContainerType<?> containerType, int windowId, PlayerInventory playerInventory, IInventory inventory) {
        super(containerType, windowId);
        this.inventory = inventory;
        inventory.func_174889_b(playerInventory.field_70458_d);
        int numRows = this.inventory.func_70302_i_() / 9;
        for (int chestRow = 0; chestRow < numRows; ++chestRow) {
            for (int chestCol = 0; chestCol < 9; ++chestCol) {
                this.func_75146_a(new MoveableSlot(inventory, chestCol + chestRow * 9, 8 + chestCol * 18, 18 + chestRow * 18));
            }
        }
        int leftCol = 8;
        int heighOffset = 150;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.func_75146_a(new Slot((IInventory)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, heighOffset - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, heighOffset - 24));
        }
        if (playerInventory.field_70458_d.field_70170_p.field_72995_K) {
            this.setDisplayRow(0);
        }
    }

    public IInventory getItemTowerInventory() {
        return this.inventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDisplayRow(int row) {
        int minSlot = row * 9;
        int maxSlot = (row + 2) * 9;
        int numRows = this.inventory.func_70302_i_() / 9;
        for (int slotIndex = 0; slotIndex < numRows * 9; ++slotIndex) {
            int modColumn;
            int modRow;
            if (row == numRows - 1) {
                if (slotIndex >= minSlot && slotIndex < maxSlot) {
                    modRow = (int)Math.floor((double)(slotIndex - minSlot) / 9.0);
                    modColumn = slotIndex % 9;
                    ((MoveableSlot)((Object)this.field_75151_b.get(slotIndex))).setSlotPosition(8 + modColumn * 18, 18 + modRow * 18);
                    continue;
                }
                if (slotIndex >= 0 && slotIndex < 9) {
                    modRow = (int)Math.floor((double)(slotIndex + maxSlot - minSlot - 9) / 9.0);
                    modColumn = slotIndex % 9;
                    ((MoveableSlot)((Object)this.field_75151_b.get(slotIndex))).setSlotPosition(8 + modColumn * 18, 18 + modRow * 18);
                    continue;
                }
                ((MoveableSlot)((Object)this.field_75151_b.get(slotIndex))).setSlotDisabled();
                continue;
            }
            if (slotIndex >= minSlot && slotIndex < maxSlot) {
                modRow = (int)Math.floor((double)(slotIndex - minSlot) / 9.0);
                modColumn = slotIndex % 9;
                ((MoveableSlot)((Object)this.field_75151_b.get(slotIndex))).setSlotPosition(8 + modColumn * 18, 18 + modRow * 18);
                continue;
            }
            ((MoveableSlot)((Object)this.field_75151_b.get(slotIndex))).setSlotDisabled();
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int maxSlot = this.inventory.func_70302_i_();
            if (index < maxSlot ? !this.func_75135_a(itemstack1, maxSlot, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, maxSlot, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
    }

    public static class ItemTowerContainerFactory<T extends Container>
    implements IContainerFactory<ItemTowerContainer> {
        public ItemTowerContainer create(int windowId, PlayerInventory inv, PacketBuffer data) {
            World world = inv.field_70458_d.field_70170_p;
            BlockPos pos = data.func_179259_c();
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof ItemTowerTileEntity) {
                ItemTowerTileEntity towerTileEntity = (ItemTowerTileEntity)te;
                return new ItemTowerContainer((ContainerType)StorageContainerTypes.ITEM_TOWER.get(), windowId, inv, (IInventory)new ItemTowerInventory(towerTileEntity.getItemTowers(), pos));
            }
            return new ItemTowerContainer((ContainerType)StorageContainerTypes.ITEM_TOWER.get(), windowId, inv, (IInventory)new Inventory(18));
        }
    }
}

