/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.inventory;

import com.grim3212.assorted.storage.common.inventory.MoveableSlot;
import com.grim3212.assorted.storage.common.inventory.StorageContainerTypes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LockerContainer
extends Container {
    private final IInventory inventory;
    private final int numRows;

    public static LockerContainer createLockerContainer(int windowId, PlayerInventory playerInventory) {
        return new LockerContainer((ContainerType)StorageContainerTypes.LOCKER.get(), windowId, playerInventory, (IInventory)new Inventory(45), 5);
    }

    public static LockerContainer createLockerContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new LockerContainer((ContainerType)StorageContainerTypes.LOCKER.get(), windowId, playerInventory, inventory, 5);
    }

    public static LockerContainer createDualLockerContainer(int windowId, PlayerInventory playerInventory) {
        return new LockerContainer((ContainerType)StorageContainerTypes.DUAL_LOCKER.get(), windowId, playerInventory, (IInventory)new Inventory(90), 10);
    }

    public static LockerContainer createDualLockerContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new LockerContainer((ContainerType)StorageContainerTypes.DUAL_LOCKER.get(), windowId, playerInventory, inventory, 10);
    }

    public LockerContainer(ContainerType<?> containerType, int windowId, PlayerInventory playerInventory, IInventory inventory, int numRows) {
        super(containerType, windowId);
        this.inventory = inventory;
        this.numRows = numRows;
        inventory.func_174889_b(playerInventory.field_70458_d);
        for (int chestRow = 0; chestRow < numRows; ++chestRow) {
            for (int chestCol = 0; chestCol < 9; ++chestCol) {
                this.func_75146_a(new MoveableSlot(inventory, chestCol + chestRow * 9, 8 + chestCol * 18, 18 + chestRow * 18));
            }
        }
        int leftCol = 8;
        int heighOffset = 203;
        if (this.numRows > 5) {
            ++heighOffset;
        }
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.func_75146_a(new Slot((IInventory)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, heighOffset - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, heighOffset - 24));
        }
        if (playerInventory.field_70458_d.field_70170_p.field_72995_K) {
            this.setDisplayRow(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDisplayRow(int row) {
        int minSlot = row * 9;
        int maxSlot = (row + 5) * 9;
        for (int slotIndex = 0; slotIndex < this.numRows * 9; ++slotIndex) {
            if (slotIndex >= minSlot && slotIndex < maxSlot) {
                int modRow = (int)Math.floor((double)(slotIndex - minSlot) / 9.0);
                int modColumn = slotIndex % 9;
                ((MoveableSlot)((Object)this.field_75151_b.get(slotIndex))).setSlotPosition(8 + modColumn * 18, 18 + modRow * 18);
                continue;
            }
            ((MoveableSlot)((Object)this.field_75151_b.get(slotIndex))).setSlotDisabled();
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int maxSlot = this.inventory.func_70302_i_();
            if (index < maxSlot ? !this.func_75135_a(itemstack1, maxSlot, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, maxSlot, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
    }
}

