/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.storage.common.item;

import com.google.common.collect.Maps;
import com.grim3212.assorted.storage.common.block.StorageBlocks;
import com.grim3212.assorted.storage.common.block.tileentity.BaseLockedTileEntity;
import com.grim3212.assorted.storage.common.item.CombinationItem;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class PadlockItem
extends CombinationItem {
    private final Map<Block, Block> doorMapping = Maps.newHashMap();

    public PadlockItem(Item.Properties properties) {
        super(properties);
        this.doorMapping.put(Blocks.field_180413_ao, (Block)StorageBlocks.LOCKED_OAK_DOOR.get());
        this.doorMapping.put(Blocks.field_180414_ap, (Block)StorageBlocks.LOCKED_SPRUCE_DOOR.get());
        this.doorMapping.put(Blocks.field_180412_aq, (Block)StorageBlocks.LOCKED_BIRCH_DOOR.get());
        this.doorMapping.put(Blocks.field_180410_as, (Block)StorageBlocks.LOCKED_ACACIA_DOOR.get());
        this.doorMapping.put(Blocks.field_180411_ar, (Block)StorageBlocks.LOCKED_JUNGLE_DOOR.get());
        this.doorMapping.put(Blocks.field_180409_at, (Block)StorageBlocks.LOCKED_DARK_OAK_DOOR.get());
        this.doorMapping.put(Blocks.field_235360_mS_, (Block)StorageBlocks.LOCKED_CRIMSON_DOOR.get());
        this.doorMapping.put(Blocks.field_235361_mT_, (Block)StorageBlocks.LOCKED_WARPED_DOOR.get());
        this.doorMapping.put(Blocks.field_150454_av, (Block)StorageBlocks.LOCKED_IRON_DOOR.get());
        Block quartzDoor = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("assorteddecor:quartz_door"));
        if (quartzDoor != Blocks.field_150350_a) {
            this.doorMapping.put(quartzDoor, (Block)StorageBlocks.LOCKED_QUARTZ_DOOR.get());
        }
    }

    private Block getMatchingDoor(Block doorIn) {
        if (this.doorMapping.containsKey(doorIn)) {
            return this.doorMapping.get(doorIn);
        }
        return Blocks.field_150350_a;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        if (world.func_180495_p(pos).func_177230_c() instanceof DoorBlock && this.tryPlaceLock(world, pos, player, hand)) {
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    private boolean tryPlaceLock(World worldIn, BlockPos pos, PlayerEntity entityplayer, Hand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (itemstack.func_77942_o()) {
            String code;
            String string = code = itemstack.func_77978_p().func_150297_b("Storage_Lock", 8) ? itemstack.func_77978_p().func_74779_i("Storage_Lock") : "";
            if (!code.isEmpty()) {
                BlockState currentDoor = worldIn.func_180495_p(pos);
                Block newDoor = this.getMatchingDoor(currentDoor.func_177230_c());
                if (newDoor == Blocks.field_150350_a) {
                    return false;
                }
                if (!entityplayer.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)newDoor.func_176223_P().func_206870_a((Property)DoorBlock.field_176520_a, currentDoor.func_177229_b((Property)DoorBlock.field_176520_a))).func_206870_a((Property)DoorBlock.field_176519_b, currentDoor.func_177229_b((Property)DoorBlock.field_176519_b))).func_206870_a((Property)DoorBlock.field_176521_M, currentDoor.func_177229_b((Property)DoorBlock.field_176521_M))).func_206870_a((Property)DoorBlock.field_176523_O, currentDoor.func_177229_b((Property)DoorBlock.field_176523_O)), 3);
                worldIn.func_184133_a(entityplayer, pos, SoundEvents.field_187654_U, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
                BaseLockedTileEntity currentTE = (BaseLockedTileEntity)worldIn.func_175625_s(pos);
                currentTE.setLockCode(code);
                if (currentDoor.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
                    BlockState downState = worldIn.func_180495_p(pos.func_177977_b());
                    worldIn.func_180501_a(pos.func_177977_b(), (BlockState)((BlockState)((BlockState)((BlockState)newDoor.func_176223_P().func_206870_a((Property)DoorBlock.field_176520_a, downState.func_177229_b((Property)DoorBlock.field_176520_a))).func_206870_a((Property)DoorBlock.field_176519_b, downState.func_177229_b((Property)DoorBlock.field_176519_b))).func_206870_a((Property)DoorBlock.field_176521_M, downState.func_177229_b((Property)DoorBlock.field_176521_M))).func_206870_a((Property)DoorBlock.field_176523_O, downState.func_177229_b((Property)DoorBlock.field_176523_O)), 3);
                    BaseLockedTileEntity downTE = (BaseLockedTileEntity)worldIn.func_175625_s(pos.func_177977_b());
                    downTE.setLockCode(code);
                } else {
                    BlockState upState = worldIn.func_180495_p(pos.func_177984_a());
                    worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)((BlockState)newDoor.func_176223_P().func_206870_a((Property)DoorBlock.field_176520_a, upState.func_177229_b((Property)DoorBlock.field_176520_a))).func_206870_a((Property)DoorBlock.field_176519_b, upState.func_177229_b((Property)DoorBlock.field_176519_b))).func_206870_a((Property)DoorBlock.field_176521_M, upState.func_177229_b((Property)DoorBlock.field_176521_M))).func_206870_a((Property)DoorBlock.field_176523_O, upState.func_177229_b((Property)DoorBlock.field_176523_O)), 3);
                    BaseLockedTileEntity upTE = (BaseLockedTileEntity)worldIn.func_175625_s(pos.func_177984_a());
                    upTE.setLockCode(code);
                }
                return true;
            }
        }
        return false;
    }
}

