/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class KnockBackPacket
implements NetworkHelper.IPacket {
    private float xv;
    private float zv;

    public KnockBackPacket() {
    }

    public KnockBackPacket(float x, float z) {
        this.xv = x;
        this.zv = z;
    }

    @Override
    public void encode(Object msg, FriendlyByteBuf packetBuffer) {
        KnockBackPacket knockBackPacket = (KnockBackPacket)msg;
        packetBuffer.writeFloat(knockBackPacket.xv);
        packetBuffer.writeFloat(knockBackPacket.zv);
    }

    @Override
    public <MSG> MSG decode(FriendlyByteBuf packetBuffer) {
        KnockBackPacket knockBackPacket = new KnockBackPacket();
        knockBackPacket.xv = packetBuffer.readFloat();
        knockBackPacket.zv = packetBuffer.readFloat();
        return (MSG)knockBackPacket;
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        KnockBackPacket knockBackPacket = (KnockBackPacket)msg;
        InfernalMobsClient.onKnockBackPacket(knockBackPacket.xv, knockBackPacket.zv);
        contextSupplier.get().setPacketHandled(true);
    }
}

