/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.api;

import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public interface IEntityPortalInfo
extends INBTSerializable<CompoundNBT> {
    public static final int TELEPORT_COOLDOWN = 100;

    public boolean isInPortalFluid();

    public boolean isInReclaimer();

    public void setInPortalFluid(boolean var1);

    public void setInReclaimer(boolean var1);

    public int getTeleportCooldown();

    public void setTeleportCooldown(int var1);

    default public void enterReclaimer() {
        if (this.getTeleportCooldown() > 0) {
            this.setTeleportCooldown(100);
        } else {
            this.setInReclaimer(true);
        }
    }

    default public void enterPortalFluid() {
        if (this.getTeleportCooldown() > 0) {
            this.setTeleportCooldown(100);
        } else {
            this.setInPortalFluid(true);
        }
    }

    default public void reset() {
        this.setInPortalFluid(false);
        this.setInReclaimer(false);
        this.setTeleportCooldown(100);
    }

    default public void serverTick(Entity entity, BiConsumer<Entity, IEntityPortalInfo> portalTeleportHandler, BiConsumer<Entity, IEntityPortalInfo> reclaimerTeleportHandler) {
        if (this.isInReclaimer()) {
            this.setInReclaimer(false);
            reclaimerTeleportHandler.accept(entity, this);
        }
        if (this.isInPortalFluid()) {
            this.setInPortalFluid(false);
            portalTeleportHandler.accept(entity, this);
        }
        if (this.getTeleportCooldown() > 0) {
            this.setTeleportCooldown(this.getTeleportCooldown() - 1);
        }
    }
}

