/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.api;

import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.util.INBTSerializable;

public interface IPlayerPortalInfo
extends INBTSerializable<CompoundNBT> {
    public static final int PORTAL_COOLDOWN = 10;
    public static final int RECLAIMER_COOLDOWN = 10;

    public int getReclaimerCounter();

    public int getReclaimerCooldown();

    public boolean isInReclaimer();

    public int getPortalFluidCounter();

    public int getPortalFluidCooldown();

    public boolean isInPortalFluid();

    public void setReclaimerCounter(int var1);

    public void setReclaimerCooldown(int var1);

    public void setInReclaimer(boolean var1);

    public void setPortalFluidCounter(int var1);

    public void setPortalFluidCooldown(int var1);

    public void setInPortalFluid(boolean var1);

    public float getTimeInPortalFluid();

    public float getPrevTimeInPortalFluid();

    public float getTimeInReclaimer();

    public float getPrevTimeInReclaimer();

    public void setTimeInPortalFluid(float var1);

    public void setPrevTimeInPortalFluid(float var1);

    public void setTimeInReclaimer(float var1);

    public void setPrevTimeInReclaimer(float var1);

    default public void offsetReclaimerCounter(int offset) {
        this.setReclaimerCounter(this.getReclaimerCounter() + offset);
    }

    default public void offsetReclaimerCooldown(int offset) {
        this.setReclaimerCooldown(this.getReclaimerCooldown() + offset);
    }

    default public void offsetPortalFluidCounter(int offset) {
        this.setPortalFluidCounter(this.getPortalFluidCounter() + offset);
    }

    default public void offsetPortalFluidCooldown(int offset) {
        this.setPortalFluidCooldown(this.getPortalFluidCooldown() + offset);
    }

    default public void offsetTimeInPortalFluid(float offset) {
        this.setTimeInPortalFluid(this.getTimeInPortalFluid() + offset);
    }

    default public void offsetTimeInReclaimer(float offset) {
        this.setTimeInReclaimer(this.getTimeInReclaimer() + offset);
    }

    default public void enterReclaimer() {
        if (this.getReclaimerCooldown() > 0) {
            this.setReclaimerCooldown(10);
        } else {
            this.setInReclaimer(true);
        }
    }

    default public void enterPortalFluid() {
        if (this.getPortalFluidCooldown() > 0) {
            this.setPortalFluidCooldown(10);
        } else {
            this.setInPortalFluid(true);
        }
    }

    default public void reset() {
        this.setReclaimerCounter(0);
        this.setReclaimerCooldown(10);
        this.setInReclaimer(false);
        this.setPortalFluidCounter(0);
        this.setPortalFluidCooldown(10);
        this.setInPortalFluid(false);
    }

    default public void serverTick(PlayerEntity player, BiConsumer<Entity, IPlayerPortalInfo> portalTeleportHandler, BiConsumer<Entity, IPlayerPortalInfo> reclaimerTeleportHandler) {
        this.setDEBUGserverTickCounter(this.getDEBUGserverTickCounter() + 1);
        if (this.isInReclaimer()) {
            this.offsetReclaimerCounter(1);
            if (!player.func_184218_aH() && this.getReclaimerCounter() >= 80) {
                this.setReclaimerCounter(80);
                this.setReclaimerCooldown(10);
                reclaimerTeleportHandler.accept((Entity)player, this);
            }
            this.setInReclaimer(false);
        } else {
            if (this.getReclaimerCounter() > 0) {
                this.offsetReclaimerCounter(-4);
            }
            if (this.getReclaimerCounter() < 0) {
                this.setReclaimerCounter(0);
            }
        }
        if (this.isInPortalFluid()) {
            this.offsetPortalFluidCounter(1);
            if (!player.func_184218_aH() && this.getPortalFluidCounter() >= 80) {
                this.setPortalFluidCounter(80);
                this.setPortalFluidCooldown(10);
                portalTeleportHandler.accept((Entity)player, this);
            }
            this.setInPortalFluid(false);
        } else {
            if (this.getPortalFluidCounter() > 0) {
                this.offsetPortalFluidCounter(-4);
            }
            if (this.getPortalFluidCounter() < 0) {
                this.setPortalFluidCounter(0);
            }
        }
        if (this.getReclaimerCooldown() > 0) {
            this.offsetReclaimerCooldown(-1);
        }
        if (this.getPortalFluidCooldown() > 0) {
            this.offsetPortalFluidCooldown(-1);
        }
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_193107_ct = null;
        }
    }

    default public void clientTick(PlayerEntity player) {
        this.setDEBUGclientTickCounter(this.getDEBUGclientTickCounter() + 1);
        this.setPrevTimeInPortalFluid(this.getTimeInPortalFluid());
        this.setPrevTimeInReclaimer(this.getTimeInReclaimer());
        if (this.isInPortalFluid()) {
            if (Minecraft.func_71410_x().field_71462_r != null && !Minecraft.func_71410_x().field_71462_r.func_231177_au__()) {
                if (Minecraft.func_71410_x().field_71462_r instanceof ContainerScreen) {
                    player.func_71053_j();
                }
                Minecraft.func_71410_x().func_147108_a(null);
            }
            if (this.getTimeInPortalFluid() == 0.0f) {
                player.field_70170_p.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187814_ei, SoundCategory.AMBIENT, 0.25f, new Random().nextFloat() * 0.4f + 0.8f);
            }
            this.offsetTimeInPortalFluid(0.0125f);
            if (this.getTimeInPortalFluid() >= 1.0f) {
                this.setTimeInPortalFluid(1.0f);
            }
            this.setInPortalFluid(false);
        } else if (player.func_70644_a(Effects.field_76431_k) && player.func_70660_b(Effects.field_76431_k).func_76459_b() > 60) {
            this.offsetTimeInPortalFluid(0.006666667f);
            if (this.getTimeInPortalFluid() > 1.0f) {
                this.setTimeInPortalFluid(1.0f);
            }
        } else {
            if (this.getTimeInPortalFluid() > 0.0f) {
                this.offsetTimeInPortalFluid(-0.05f);
            }
            if (this.getTimeInPortalFluid() < 0.0f) {
                this.setTimeInPortalFluid(0.0f);
            }
        }
        if (this.isInReclaimer()) {
            if (Minecraft.func_71410_x().field_71462_r != null && !Minecraft.func_71410_x().field_71462_r.func_231177_au__()) {
                if (Minecraft.func_71410_x().field_71462_r instanceof ContainerScreen) {
                    player.func_71053_j();
                }
                Minecraft.func_71410_x().func_147108_a(null);
            }
            if (this.getTimeInReclaimer() == 0.0f) {
                player.field_70170_p.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187814_ei, SoundCategory.AMBIENT, 0.25f, 0.8f);
            }
            this.offsetTimeInReclaimer(0.0125f);
            if (this.getTimeInReclaimer() >= 1.0f) {
                this.setTimeInReclaimer(1.0f);
            }
            this.setInReclaimer(false);
        } else if (player.func_70644_a(Effects.field_76431_k) && player.func_70660_b(Effects.field_76431_k).func_76459_b() > 60) {
            this.offsetTimeInReclaimer(0.006666667f);
            if (this.getTimeInReclaimer() > 1.0f) {
                this.setTimeInReclaimer(1.0f);
            }
        } else {
            if (this.getTimeInReclaimer() > 0.0f) {
                this.offsetTimeInReclaimer(-0.05f);
            }
            if (this.getTimeInReclaimer() < 0.0f) {
                this.setTimeInReclaimer(0.0f);
            }
        }
        if (this.getPortalFluidCooldown() > 0) {
            this.offsetPortalFluidCooldown(-1);
        }
        if (this.getReclaimerCooldown() > 0) {
            this.offsetReclaimerCooldown(-1);
        }
    }

    public int getDEBUGclientTickCounter();

    public int getDEBUGserverTickCounter();

    public int getDEBUGportalCounter();

    public void setDEBUGclientTickCounter(int var1);

    public void setDEBUGserverTickCounter(int var1);

    public void setDEBUGportalCounter(int var1);
}

