/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.block;

import com.yungnickyoung.minecraft.betterportals.api.BetterPortalsCapabilities;
import com.yungnickyoung.minecraft.betterportals.init.BPModFluids;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class PortalFluidBlock
extends FlowingFluidBlock {
    public PortalFluidBlock() {
        super(() -> BPModFluids.PORTAL_FLUID, AbstractBlock.Properties.func_200945_a((Material)Material.field_151587_i).func_200942_a().func_200943_b(100.0f).func_235838_a_(state -> 7).func_222380_e());
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (entity instanceof PlayerEntity && !entity.func_184218_aH() && !entity.func_184207_aI()) {
            entity.getCapability(BetterPortalsCapabilities.PLAYER_PORTAL_INFO).ifPresent(playerPortalInfo -> {
                playerPortalInfo.setDEBUGportalCounter(playerPortalInfo.getDEBUGportalCounter() + 1);
                playerPortalInfo.enterPortalFluid();
            });
        } else if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && !worldIn.field_72995_K) {
            entity.getCapability(BetterPortalsCapabilities.ENTITY_PORTAL_INFO).ifPresent(entityPortalInfo -> entityPortalInfo.enterPortalFluid());
        }
    }

    @ParametersAreNonnullByDefault
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.reactWithNeighbors(worldIn, pos, state)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), 35);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (this.reactWithNeighbors(worldIn, pos, state)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), 35);
        }
    }

    private boolean reactWithNeighbors(World worldIn, BlockPos pos, BlockState state) {
        boolean isAboveSoulSoil = worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_235336_cN_);
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN) continue;
            BlockPos blockpos = pos.func_177972_a(direction);
            Fluid fluid = worldIn.func_204610_c(blockpos).getFluidState().func_206886_c();
            if (fluid != Fluids.field_204541_a && fluid != BPModFluids.PORTAL_FLUID && fluid != BPModFluids.PORTAL_FLUID_FLOWING) {
                Block replacementBlock = worldIn.func_204610_c(pos).func_206889_d() ? Blocks.field_150343_Z : Blocks.field_150347_e;
                worldIn.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)pos, (BlockPos)pos, (BlockState)replacementBlock.func_176223_P()));
                this.triggerMixEffects((IWorld)worldIn, pos);
                return false;
            }
            if (!isAboveSoulSoil || !worldIn.func_180495_p(blockpos).func_203425_a(Blocks.field_205164_gk)) continue;
            worldIn.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)pos, (BlockPos)pos, (BlockState)Blocks.field_235337_cO_.func_176223_P()));
            this.triggerMixEffects((IWorld)worldIn, pos);
            return false;
        }
        return true;
    }

    private void triggerMixEffects(IWorld worldIn, BlockPos pos) {
        worldIn.func_217379_c(1501, pos, 0);
    }
}

