/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.block;

import com.yungnickyoung.minecraft.betterportals.init.BPModBlocks;
import com.yungnickyoung.minecraft.betterportals.tileentity.ReclaimerTileEntity;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariants;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ReclaimerBlock
extends ContainerBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public ReclaimerBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151648_G).func_200943_b(3.0f).func_235838_a_(ReclaimerBlock.getLightValue(15)).func_226896_b_().func_235828_a_((state, reader, pos) -> false));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{POWERED});
    }

    public boolean func_149653_t(BlockState p_149653_1_) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (this.shouldBePowered(world, pos, this.getPowerBlock(world))) {
            world.func_184133_a(null, pos, SoundEvents.field_206938_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                blockState = (BlockState)blockState.func_235896_a_((Property)POWERED);
                world.func_180501_a(pos, blockState, 3);
                world.func_195593_d(pos, (Block)this);
            }
        }
    }

    public void func_220069_a(BlockState blockState, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.field_72995_K) {
            boolean wasPowered = false;
            try {
                wasPowered = (Boolean)world.func_180495_p(pos).func_177229_b((Property)POWERED);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BlockState powerBlock = this.getPowerBlock(world);
            boolean powered = this.shouldBePowered(world, pos, powerBlock);
            if (wasPowered && !powered) {
                world.func_184133_a(null, pos, SoundEvents.field_206940_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (!wasPowered && powered) {
                world.func_184133_a(null, pos, SoundEvents.field_206938_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (world.func_180495_p(pos).func_177230_c() == BPModBlocks.RECLAIMER_BLOCK && ((Boolean)world.func_180495_p(pos).func_177229_b((Property)POWERED)).booleanValue()) {
            world.func_184133_a(null, pos, SoundEvents.field_206940_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new ReclaimerTileEntity();
    }

    public float[] getColor(World world, boolean isPowered) {
        String dimensionName = world.func_234923_W_().func_240901_a_().toString();
        MonolithVariantSettings settings = MonolithVariants.get().getVariantForDimension(dimensionName);
        if (settings == null) {
            float[] fArray;
            if (isPowered) {
                float[] fArray2 = new float[3];
                fArray2[0] = 1.0f;
                fArray2[1] = 0.8627451f;
                fArray = fArray2;
                fArray2[2] = 0.4509804f;
            } else {
                float[] fArray3 = new float[3];
                fArray3[0] = 0.078431375f;
                fArray3[1] = 0.047058824f;
                fArray = fArray3;
                fArray3[2] = 0.14117648f;
            }
            return fArray;
        }
        return isPowered ? settings.getPoweredBeamColor().getColorComponentValues() : settings.getUnpoweredBeamColor().getColorComponentValues();
    }

    private static ToIntFunction<BlockState> getLightValue(int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? lightValue : 0;
    }

    private boolean shouldBePowered(World world, BlockPos pos, BlockState powerBlock) {
        if (powerBlock == null) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (world.func_180495_p(pos.func_177972_a(direction)) == powerBlock) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return 15;
    }

    private BlockState getPowerBlock(World world) {
        String dimensionName = world.func_234923_W_().func_240901_a_().toString();
        MonolithVariantSettings settings = MonolithVariants.get().getVariantForDimension(dimensionName);
        return settings == null ? null : settings.getPowerBlock();
    }
}

