/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class NBTCapabilityProvider<T extends INBTSerializable<CompoundNBT>>
implements ICapabilitySerializable<CompoundNBT> {
    private final Capability<T> capability;
    private final T value;
    private final LazyOptional<T> lazyValue;

    public NBTCapabilityProvider(Capability<T> capability, T value) {
        this.capability = capability;
        this.value = value;
        this.lazyValue = LazyOptional.of(() -> this.value);
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> capability, @Nullable Direction side) {
        return this.capability.orEmpty(capability, this.lazyValue);
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)this.value.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.value.deserializeNBT((INBT)nbt);
    }
}

