/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yungnickyoung.minecraft.betterportals.api.BetterPortalsCapabilities;
import com.yungnickyoung.minecraft.betterportals.client.ReclaimerTileEntityRenderer;
import com.yungnickyoung.minecraft.betterportals.init.BPModBlocks;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariants;
import com.yungnickyoung.minecraft.betterportals.world.variant.PortalLakeVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.PortalLakeVariants;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.FluidState;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class OverlayRenderer {
    private static final ResourceLocation TEXTURE_UNDERWATER = new ResourceLocation("betterportals", "textures/misc/portal_fluid_underwater.png");
    private static final ResourceLocation TEXTURE_RECLAIMER = ReclaimerTileEntityRenderer.END_GATEWAY_BEAM_TEXTURE;

    public static void renderUnderwaterOverlay(RenderBlockOverlayEvent event) {
        double fluidHeight;
        double eyeHeight = event.getPlayer().func_226280_cw_() - 0.1111111119389534;
        BlockPos blockpos = new BlockPos(event.getPlayer().func_226277_ct_(), eyeHeight, event.getPlayer().func_226281_cx_());
        FluidState fluidstate = event.getPlayer().field_70170_p.func_204610_c(blockpos);
        BlockState blockState = event.getPlayer().field_70170_p.func_180495_p(blockpos);
        if (blockState.func_177230_c() == BPModBlocks.PORTAL_FLUID_BLOCK && (fluidHeight = (double)((float)blockpos.func_177956_o() + fluidstate.func_215679_a((IBlockReader)event.getPlayer().field_70170_p, blockpos))) > eyeHeight) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(TEXTURE_UNDERWATER);
            BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
            float brightness = minecraft.field_71439_g.func_70013_c();
            float alpha = 0.8f;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float yaw = -minecraft.field_71439_g.field_70177_z / 64.0f;
            float pitch = minecraft.field_71439_g.field_70125_A / 64.0f;
            Matrix4f matrix4f = event.getMatrixStack().func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            bufferbuilder.func_227888_a_(matrix4f, -1.0f, -1.0f, -0.5f).func_227885_a_(brightness, brightness, brightness, alpha).func_225583_a_(4.0f + yaw, 4.0f + pitch).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, 1.0f, -1.0f, -0.5f).func_227885_a_(brightness, brightness, brightness, alpha).func_225583_a_(0.0f + yaw, 4.0f + pitch).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, 1.0f, 1.0f, -0.5f).func_227885_a_(brightness, brightness, brightness, alpha).func_225583_a_(0.0f + yaw, 0.0f + pitch).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, -1.0f, 1.0f, -0.5f).func_227885_a_(brightness, brightness, brightness, alpha).func_225583_a_(4.0f + yaw, 0.0f + pitch).func_181675_d();
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            RenderSystem.disableBlend();
        }
    }

    public static void renderPortalOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft.func_71410_x().field_71439_g.getCapability(BetterPortalsCapabilities.PLAYER_PORTAL_INFO).ifPresent(playerPortalInfo -> {
            float portalTime = playerPortalInfo.getPrevTimeInPortalFluid() + (playerPortalInfo.getTimeInPortalFluid() - playerPortalInfo.getPrevTimeInPortalFluid()) * event.getPartialTicks();
            if (portalTime <= 0.0f) {
                return;
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71439_g.func_70644_a(Effects.field_76431_k)) {
                return;
            }
            String sourceDimension = minecraft.field_71441_e.func_234923_W_().func_240901_a_().toString();
            PortalLakeVariantSettings settings = PortalLakeVariants.get().getVariantForDimension(sourceDimension);
            if (settings == null) {
                return;
            }
            float[] colors = settings.getFluidColor().getColorComponentValues();
            if (portalTime < 1.0f) {
                portalTime = portalTime * 0.8f + 0.2f;
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            TextureAtlasSprite textureatlassprite = minecraft.func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150427_aO.func_176223_P());
            float minU = textureatlassprite.func_94209_e();
            float minV = textureatlassprite.func_94206_g();
            float maxU = textureatlassprite.func_94212_f();
            float maxV = textureatlassprite.func_94210_h();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            double scaledWidth = event.getWindow().func_198107_o();
            double scaledHeight = event.getWindow().func_198087_p();
            bufferbuilder.func_225582_a_(0.0, scaledHeight, -90.0).func_227885_a_(colors[0], colors[1], colors[2], portalTime).func_225583_a_(minU, maxV).func_181675_d();
            bufferbuilder.func_225582_a_(scaledWidth, scaledHeight, -90.0).func_227885_a_(colors[0], colors[1], colors[2], portalTime).func_225583_a_(maxU, maxV).func_181675_d();
            bufferbuilder.func_225582_a_(scaledWidth, 0.0, -90.0).func_227885_a_(colors[0], colors[1], colors[2], portalTime).func_225583_a_(maxU, minV).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_227885_a_(colors[0], colors[1], colors[2], portalTime).func_225583_a_(minU, minV).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.disableBlend();
        });
    }

    public static void renderReclaimerOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft.func_71410_x().field_71439_g.getCapability(BetterPortalsCapabilities.PLAYER_PORTAL_INFO).ifPresent(playerPortalInfo -> {
            float reclaimerTime = playerPortalInfo.getPrevTimeInReclaimer() + (playerPortalInfo.getTimeInReclaimer() - playerPortalInfo.getPrevTimeInReclaimer()) * event.getPartialTicks();
            if (reclaimerTime <= 0.0f) {
                return;
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71439_g.func_70644_a(Effects.field_76431_k)) {
                return;
            }
            String sourceDimension = minecraft.field_71441_e.func_234923_W_().func_240901_a_().toString();
            MonolithVariantSettings settings = MonolithVariants.get().getVariantForDimension(sourceDimension);
            if (settings == null) {
                return;
            }
            float[] colors = settings.getPoweredBeamColor().getColorComponentValues();
            float alpha = reclaimerTime;
            if (alpha < 1.0f) {
                alpha *= alpha;
                alpha *= alpha;
                alpha = alpha * 0.8f + 0.2f;
            }
            alpha *= 0.8f;
            float speed = reclaimerTime * reclaimerTime;
            speed *= speed;
            speed = speed * 0.8f + 0.2f;
            float yOffset = speed * 0.8f * (float)(minecraft.field_71439_g.field_70173_aa % 16);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            minecraft.func_110434_K().func_110577_a(TEXTURE_RECLAIMER);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            double scaledWidth = event.getWindow().func_198107_o();
            double scaledHeight = event.getWindow().func_198087_p();
            bufferbuilder.func_225582_a_(0.0, scaledHeight, -90.0).func_227885_a_(colors[0], colors[1], colors[2], alpha).func_225583_a_(4.0f, 4.0f + yOffset).func_181675_d();
            bufferbuilder.func_225582_a_(scaledWidth, scaledHeight, -90.0).func_227885_a_(colors[0], colors[1], colors[2], alpha).func_225583_a_(0.0f, 4.0f + yOffset).func_181675_d();
            bufferbuilder.func_225582_a_(scaledWidth, 0.0, -90.0).func_227885_a_(colors[0], colors[1], colors[2], alpha).func_225583_a_(0.0f, yOffset).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_227885_a_(colors[0], colors[1], colors[2], alpha).func_225583_a_(4.0f, yOffset).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.disableBlend();
        });
    }

    public static void renderDebugOverlay(RenderGameOverlayEvent.Text event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        player.getCapability(BetterPortalsCapabilities.PLAYER_PORTAL_INFO).ifPresent(playerPortalInfo -> {
            event.getRight().add("Render time: " + playerPortalInfo.getTimeInPortalFluid());
            event.getRight().add("Prev render time: " + playerPortalInfo.getPrevTimeInPortalFluid());
        });
    }
}

