/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.yungnickyoung.minecraft.betterportals.tileentity.ReclaimerTileEntity;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class ReclaimerTileEntityRenderer
extends TileEntityRenderer<ReclaimerTileEntity> {
    public static final ResourceLocation END_GATEWAY_BEAM_TEXTURE = new ResourceLocation("textures/entity/end_gateway_beam.png");
    public static final ResourceLocation SMALL_CUBE_TEXTURE = new ResourceLocation("betterportals", "textures/entity/reclaimer_cube.png");
    private final ModelRenderer smallCubeRenderer = new ModelRenderer(24, 12, 0, 0);

    public ReclaimerTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.smallCubeRenderer.func_228300_a_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f);
    }

    @ParametersAreNonnullByDefault
    public void render(ReclaimerTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        ReclaimerTileEntityRenderer.renderBeam(tileEntity, partialTicks, matrixStack, renderTypeBuffer);
        this.renderCube(tileEntity, partialTicks, matrixStack, renderTypeBuffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderCube(ReclaimerTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        float totalTicks = (float)tileEntity.ticksExisted + partialTicks;
        float rotDegrees = tileEntity.getActiveRotation(partialTicks) * 57.295776f;
        float yOffset = MathHelper.func_76126_a((float)(totalTicks * 0.08f)) / 2.0f + 0.5f;
        yOffset = yOffset * 0.2f + 0.4f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, (double)yOffset, 0.5);
        Vector3f staticRotVec = new Vector3f(1.0f, 0.0f, 1.0f);
        staticRotVec.func_229194_d_();
        matrixStack.func_227863_a_(new Quaternion(staticRotVec, 45.0f, true));
        Vector3f rotVec = new Vector3f(0.5f, 1.0f, 0.5f);
        rotVec.func_229194_d_();
        matrixStack.func_227863_a_(new Quaternion(rotVec, rotDegrees, true));
        this.smallCubeRenderer.func_228308_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)SMALL_CUBE_TEXTURE)), combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }

    private static void renderBeam(ReclaimerTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer) {
        long time = tileEntity.func_145831_w().func_82737_E();
        boolean isPowered = tileEntity.isPowered();
        List<ReclaimerTileEntity.BeamPiece> beamSegments = tileEntity.getBeamPieces();
        float yOffset = 0.5f;
        for (int i = 0; i < beamSegments.size(); ++i) {
            ReclaimerTileEntity.BeamPiece beamSegment = beamSegments.get(i);
            ReclaimerTileEntityRenderer.renderBeamSegment(matrixStack, renderTypeBuffer, END_GATEWAY_BEAM_TEXTURE, partialTicks, 1.0f, time, yOffset, beamSegment.getHeight(), beamSegment.getColors(), isPowered ? 0.4f : 0.1f, isPowered ? 0.6f : 0.15f, isPowered ? 2.5f : 0.5f);
            yOffset += (float)beamSegment.getHeight();
        }
    }

    private static void renderBeamSegment(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, ResourceLocation textureLocation, float partialTicks, float textureScale, long totalWorldTime, float yMin, int height, float[] colors, float beamRadius, float glowRadius, float rotationAmp) {
        float yMax = yMin + (float)height;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        float rotation = rotationAmp * (float)Math.floorMod(totalWorldTime, (long)(40.0f / rotationAmp)) + partialTicks;
        float f1 = height < 0 ? rotation : -rotation;
        float f2 = MathHelper.func_226164_h_((float)(f1 * 0.2f - (float)MathHelper.func_76141_d((float)(f1 * 0.1f))));
        float red = colors[0];
        float green = colors[1];
        float blue = colors[2];
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation * 2.25f - 45.0f / rotationAmp));
        float f15 = -1.0f + f2;
        float f16 = (float)height * textureScale * (0.5f / beamRadius) + f15;
        ReclaimerTileEntityRenderer.renderPart(matrixStackIn, bufferIn.getBuffer(RenderType.func_228637_a_((ResourceLocation)textureLocation, (boolean)false)), red, green, blue, 1.0f, yMin, yMax, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, f16, f15);
        matrixStackIn.func_227865_b_();
        f15 = -1.0f + f2;
        f16 = (float)height * textureScale + f15;
        ReclaimerTileEntityRenderer.renderPart(matrixStackIn, bufferIn.getBuffer(RenderType.func_228637_a_((ResourceLocation)textureLocation, (boolean)true)), red, green, blue, 0.125f, yMin, yMax, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, f16, f15);
        matrixStackIn.func_227865_b_();
    }

    private static void renderPart(MatrixStack matrixStackIn, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, float yMin, float yMax, float x1, float z1, float x2, float z2, float p_228840_12_, float p_228840_13_, float p_228840_14_, float p_228840_15_, float u1, float u2, float v1, float v2) {
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        ReclaimerTileEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, x1, z1, x2, z2, u1, u2, v1, v2);
        ReclaimerTileEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_14_, p_228840_15_, p_228840_12_, p_228840_13_, u1, u2, v1, v2);
        ReclaimerTileEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, x2, z2, p_228840_14_, p_228840_15_, u1, u2, v1, v2);
        ReclaimerTileEntityRenderer.addQuad(matrix4f, matrix3f, bufferIn, red, green, blue, alpha, yMin, yMax, p_228840_12_, p_228840_13_, x1, z1, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, float yMin, float yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        ReclaimerTileEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        ReclaimerTileEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        ReclaimerTileEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        ReclaimerTileEntityRenderer.addVertex(matrixPos, matrixNormal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, float y, float x, float z, float texU, float texV) {
        bufferIn.func_227888_a_(matrixPos, x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(texU, texV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public boolean isGlobalRenderer(ReclaimerTileEntity tileEntity) {
        return true;
    }
}

